"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.initJsonSchemaDiagnostics = initJsonSchemaDiagnostics;
var monaco = require("monaco-editor");
var schemas_1 = require("../schemas");
function initJsonSchemaDiagnostics() {
    monaco.languages.json.jsonDefaults.setDiagnosticsOptions({
        validate: true,
        allowComments: false,
        schemaValidation: "error",
        schemas: [
            {
                uri: "https://serverlessworkflow.io/schemas/0.8/workflow.json",
                fileMatch: ["*"],
                schema: schemas_1.SW_SPEC_WORKFLOW_SCHEMA,
            },
        ],
    });
}
//# sourceMappingURL=index.js.map