export function validationPromise(yaml) {
    return new Promise((resolve, reject) => {
        const worker = new Worker("/yard-validator-worker.js");
        worker.postMessage(yaml);
        worker.onmessage = (e) => {
            const notifications = [];
            try {
                const validationResult = JSON.parse(e.data);
                for (const result of validationResult.result) {
                    for (const location of result.locations) {
                        notifications.push({
                            normalizedPosixPathRelativeToTheWorkspaceRoot: "",
                            severity: "ERROR",
                            message: result.issue,
                            type: "PROBLEM",
                            position: {
                                startLineNumber: location.rowInFile,
                                startColumn: 0,
                                endLineNumber: 0,
                                endColumn: 0,
                            },
                        });
                    }
                }
            }
            catch (e) {
            }
            resolve(notifications);
            worker.terminate();
        };
    });
}
//# sourceMappingURL=main.js.map