import "@patternfly/react-styles/css/components/Drawer/drawer.css";
import * as React from "react";
import { BeeGwtService, BoxedExpression, DmnDataType, Normalized, PmmlDocument } from "./api";
import { OnExpressionChange } from "./BoxedExpressionEditorContext";
import { FeelIdentifiers } from "@kie-tools/dmn-feel-antlr4-parser";
import "./base-no-reset-wrapped.css";
import "./@types/react-table";
export type OnRequestFeelIdentifiers = () => FeelIdentifiers;
export interface BoxedExpressionEditorProps {
    beeGwtService?: BeeGwtService;
    expressionHolderId: string;
    expressionHolderName: string;
    expressionHolderTypeRef: string | undefined;
    expression: Normalized<BoxedExpression> | undefined;
    onExpressionChange: OnExpressionChange;
    widthsById: Map<string, number[]>;
    onWidthsChange: React.Dispatch<React.SetStateAction<Map<string, number[]>>>;
    isResetSupportedOnRootExpression?: boolean;
    dataTypes: DmnDataType[];
    isReadOnly?: boolean;
    pmmlDocuments?: PmmlDocument[];
    evaluationHitsCountById?: Map<string, number>;
    scrollableParentRef: React.RefObject<HTMLElement>;
    onRequestFeelIdentifiers?: OnRequestFeelIdentifiers;
    hideDmn14BoxedExpressions?: boolean;
}
export declare function BoxedExpressionEditor({ dataTypes, isReadOnly, expressionHolderId, expressionHolderName, expressionHolderTypeRef, expression, onExpressionChange, beeGwtService, isResetSupportedOnRootExpression, scrollableParentRef, pmmlDocuments, onRequestFeelIdentifiers, evaluationHitsCountById, widthsById, onWidthsChange, hideDmn14BoxedExpressions, }: BoxedExpressionEditorProps): JSX.Element;
//# sourceMappingURL=BoxedExpressionEditor.d.ts.map