import { useCallback, useEffect, useMemo, useState } from "react";
import { generateUuid } from "../api";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
import { NavigationKeysUtils } from "../keysUtils/keyUtils";
export function useCustomContextMenuHandler(domEventTargetRef) {
    const { setCurrentlyOpenContextMenu, currentlyOpenContextMenu, editorRef, scrollableParentRef } = useBoxedExpressionEditor();
    const [scroll, setScroll] = useState({ x: 0, y: 0 });
    const [position, setPosition] = useState({ x: 0, y: 0 });
    const [isOpen, setOpen] = useState(false);
    const id = useMemo(() => generateUuid(), []);
    const hide = useCallback((e) => {
        e.preventDefault();
        if (!isOpen || e.ctrlKey) {
            return;
        }
        setCurrentlyOpenContextMenu(undefined);
    }, [isOpen, setCurrentlyOpenContextMenu]);
    const show = useCallback((e) => {
        var _a, _b, _c, _d, _e, _f, _g, _h, _j, _k;
        e.preventDefault();
        e.stopPropagation();
        setPosition({
            x: e.pageX +
                ((_b = (_a = scrollableParentRef.current) === null || _a === void 0 ? void 0 : _a.offsetLeft) !== null && _b !== void 0 ? _b : 0) -
                ((_d = (_c = scrollableParentRef.current) === null || _c === void 0 ? void 0 : _c.getBoundingClientRect().left) !== null && _d !== void 0 ? _d : 0),
            y: e.pageY +
                ((_f = (_e = scrollableParentRef.current) === null || _e === void 0 ? void 0 : _e.offsetTop) !== null && _f !== void 0 ? _f : 0) -
                ((_h = (_g = scrollableParentRef.current) === null || _g === void 0 ? void 0 : _g.getBoundingClientRect().top) !== null && _h !== void 0 ? _h : 0),
        });
        setScroll({
            x: ((_j = scrollableParentRef.current) === null || _j === void 0 ? void 0 : _j.scrollLeft) ? 0 : window.scrollX,
            y: ((_k = scrollableParentRef.current) === null || _k === void 0 ? void 0 : _k.scrollTop) ? 0 : window.scrollY,
        });
        setCurrentlyOpenContextMenu(id);
    }, [id, scrollableParentRef, setCurrentlyOpenContextMenu]);
    useEffect(() => {
        var _a;
        function onScroll(e) {
            if (currentlyOpenContextMenu === id) {
                setScroll({
                    x: e.target.scrollLeft ? 0 : window.scrollX,
                    y: e.target.scrollTop ? 0 : window.scrollY,
                });
            }
        }
        const target = (_a = scrollableParentRef.current) !== null && _a !== void 0 ? _a : window;
        target === null || target === void 0 ? void 0 : target.addEventListener("scroll", onScroll);
        return () => {
            target === null || target === void 0 ? void 0 : target.removeEventListener("scroll", onScroll);
        };
    }, [currentlyOpenContextMenu, editorRef, id, scrollableParentRef]);
    useEffect(() => {
        setOpen(id === currentlyOpenContextMenu);
    }, [id, currentlyOpenContextMenu]);
    useEffect(() => {
        function handleEscPressed(e) {
            if (NavigationKeysUtils.isEsc(e.key)) {
                setCurrentlyOpenContextMenu(undefined);
            }
        }
        const elem = scrollableParentRef === null || scrollableParentRef === void 0 ? void 0 : scrollableParentRef.current;
        elem === null || elem === void 0 ? void 0 : elem.addEventListener("keydown", handleEscPressed);
        return () => {
            elem === null || elem === void 0 ? void 0 : elem.removeEventListener("keydown", handleEscPressed);
        };
    }, [scrollableParentRef, setCurrentlyOpenContextMenu]);
    useEffect(() => {
        const elem = domEventTargetRef === null || domEventTargetRef === void 0 ? void 0 : domEventTargetRef.current;
        if (currentlyOpenContextMenu && isOpen) {
            document.addEventListener("click", hide);
            document.addEventListener("contextmenu", hide);
            elem === null || elem === void 0 ? void 0 : elem.addEventListener("contextmenu", show);
            return () => {
                elem === null || elem === void 0 ? void 0 : elem.removeEventListener("contextmenu", show);
                document.removeEventListener("contextmenu", hide);
                document.removeEventListener("click", hide);
            };
        }
        elem === null || elem === void 0 ? void 0 : elem.addEventListener("contextmenu", show);
        return () => {
            elem === null || elem === void 0 ? void 0 : elem.removeEventListener("contextmenu", show);
        };
    }, [domEventTargetRef, hide, currentlyOpenContextMenu, isOpen, show]);
    return {
        xPos: position.x - scroll.x + 1,
        yPos: position.y - scroll.y + 1,
        isOpen,
    };
}
//# sourceMappingURL=Hooks.js.map