import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useMemo } from "react";
import { Action, DmnBuiltInDataType, } from "../api";
import { useCellWidthToFitDataRef } from "../resizing/BeeTableCellWidthToFitDataContext";
import { getCanvasFont, getTextWidth } from "../resizing/WidthsToFitData";
import { useBeeTableSelectableCellRef } from "../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor } from "../BoxedExpressionEditorContext";
import { DEFAULT_EXPRESSION_VARIABLE_NAME, ExpressionVariableMenu, } from "./ExpressionVariableMenu";
import "./ExpressionVariableCell.css";
export const ExpressionVariableCell = ({ data, rowIndex, columnIndex, onExpressionWithVariableUpdated }) => {
    const ref = React.useRef(null);
    const { isReadOnly } = useBoxedExpressionEditor();
    const { expression, variable, index, isContentAFeelExpression } = data[rowIndex];
    const onVariableUpdated = useCallback(({ name = DEFAULT_EXPRESSION_VARIABLE_NAME, typeRef = undefined }) => {
        const expressionChangedArgs = {
            action: Action.VariableChanged,
            variableUuid: variable["@_id"],
            typeChange: variable["@_typeRef"] !== typeRef
                ? {
                    from: variable["@_typeRef"],
                    to: typeRef,
                }
                : undefined,
            nameChange: variable["@_name"] !== name
                ? {
                    from: variable["@_name"],
                    to: name,
                }
                : undefined,
        };
        onExpressionWithVariableUpdated(index, {
            expression: expression
                ? {
                    ...expression,
                    "@_label": name,
                    "@_typeRef": typeRef,
                }
                : undefined,
            variable: {
                ...variable,
                "@_name": name,
                "@_typeRef": typeRef,
            },
        }, expressionChangedArgs);
    }, [onExpressionWithVariableUpdated, index, expression, variable]);
    useCellWidthToFitDataRef(rowIndex, columnIndex, useMemo(() => ({
        getWidthToFitData: () => {
            var _a, _b;
            const name = ref.current.querySelector(".expression-info-name");
            const typeRef = ref.current.querySelector(".expression-info-data-type");
            const padding = 8 * 2;
            const border = 2;
            return (padding +
                border +
                Math.max(getTextWidth((_a = name.textContent) !== null && _a !== void 0 ? _a : "", getCanvasFont(name)), getTextWidth((_b = typeRef.textContent) !== null && _b !== void 0 ? _b : "", getCanvasFont(typeRef))));
        },
    }), []));
    const { isActive } = useBeeTableSelectableCellRef(rowIndex, columnIndex, undefined, useCallback(() => `${variable["@_name"]} (${variable["@_typeRef"]}})`, [variable]));
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(variable["@_id"]);
        }
    }, [beeGwtService, variable, isActive]);
    const cellContent = useMemo(() => {
        var _a, _b;
        return (_jsxs("div", { className: `expression-info with-popover-menu`, ref: ref, children: [_jsx("p", { className: "expression-info-name pf-u-text-truncate", title: variable["@_name"], "data-ouia-component-id": "expression-info-name", "data-testid": "kie-tools--bee--expression-info-name", children: variable["@_name"] }), _jsxs("p", { className: "expression-info-data-type pf-u-text-truncate", title: (_a = variable["@_typeRef"]) !== null && _a !== void 0 ? _a : DmnBuiltInDataType.Undefined, "data-ouia-component-id": "expression-info-data-type", "data-testid": "kie-tools--bee--expression-info-data-type", children: ["(", (_b = variable["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined, ")"] })] }));
    }, [variable]);
    return (_jsx("div", { className: "expression-variable-cell", children: _jsx("div", { className: `${variable["@_id"]} expression-variable`, children: isReadOnly ? (cellContent) : (_jsx(ExpressionVariableMenu, { selectedExpressionName: variable["@_name"], selectedDataType: variable["@_typeRef"], onVariableUpdated: onVariableUpdated, variableUuid: variable["@_id"], isContentAFeelExpression: isContentAFeelExpression, children: cellContent })) }) }));
};
//# sourceMappingURL=ExpressionVariableCell.js.map