import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useCallback, useEffect, useMemo } from "react";
import { Action, BeeTableHeaderVisibility, BeeTableOperation, DmnBuiltInDataType, generateUuid, getNextAvailablePrefixedName, } from "../../api";
import { useBoxedExpressionEditorI18n } from "../../i18n";
import { NestedExpressionContainerContext } from "../../resizing/NestedExpressionContainerContext";
import { ResizerStopBehavior } from "../../resizing/ResizingWidthsContext";
import { CONTEXT_ENTRY_VARIABLE_MIN_WIDTH, INVOCATION_ARGUMENT_EXPRESSION_MIN_WIDTH, INVOCATION_EXTRA_WIDTH, INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX, INVOCATION_PARAMETER_MIN_WIDTH, } from "../../resizing/WidthConstants";
import { BeeTable } from "../../table/BeeTable";
import { useBoxedExpressionEditor, useBoxedExpressionEditorDispatch } from "../../BoxedExpressionEditorContext";
import { useNestedExpressionContainerWithNestedExpressions } from "../../resizing/Hooks";
import { ArgumentEntryExpressionCell } from "./ArgumentEntryExpressionCell";
import { ExpressionVariableCell } from "../../expressionVariable/ExpressionVariableCell";
import { DEFAULT_EXPRESSION_VARIABLE_NAME } from "../../expressionVariable/ExpressionVariableMenu";
import { getExpressionTotalMinWidth } from "../../resizing/WidthMaths";
import { useBeeTableCoordinates, useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { findAllIdsDeep } from "../../ids/ids";
import "./InvocationExpression.css";
export const INVOCATION_EXPRESSION_DEFAULT_PARAMETER_NAME = "p-1";
export function InvocationExpression({ isNested, parentElementId, expression: invocationExpression, }) {
    var _a, _b;
    const { i18n } = useBoxedExpressionEditorI18n();
    const { expressionHolderId, widthsById, isReadOnly } = useBoxedExpressionEditor();
    const { setExpression, setWidthsById } = useBoxedExpressionEditorDispatch();
    const id = invocationExpression["@_id"];
    const widths = useMemo(() => { var _a; return (_a = widthsById.get(id)) !== null && _a !== void 0 ? _a : []; }, [id, widthsById]);
    const getParametersWidth = useCallback((widths) => {
        var _a;
        return (_a = widths === null || widths === void 0 ? void 0 : widths[INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX]) !== null && _a !== void 0 ? _a : INVOCATION_PARAMETER_MIN_WIDTH;
    }, []);
    const parametersWidth = useMemo(() => getParametersWidth(widths), [getParametersWidth, widths]);
    const setParametersWidth = useCallback((newWidthAction) => {
        setWidthsById(({ newMap }) => {
            var _a;
            const prev = (_a = newMap.get(id)) !== null && _a !== void 0 ? _a : [];
            const newWidth = typeof newWidthAction === "function" ? newWidthAction(getParametersWidth(prev)) : newWidthAction;
            if (newWidth) {
                const minSize = INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX + 1;
                const newValues = [...prev];
                newValues.push(...Array(Math.max(0, minSize - newValues.length)).fill(INVOCATION_PARAMETER_MIN_WIDTH));
                newValues.splice(INVOCATION_PARAMETER_INFO_COLUMN_WIDTH_INDEX, 1, newWidth);
                newMap.set(id, newValues);
            }
        });
    }, [getParametersWidth, id, setWidthsById]);
    const [parametersResizingWidth, setParametersResizingWidth] = React.useState({
        value: parametersWidth,
        isPivoting: false,
    });
    const onColumnResizingWidthChange1 = useCallback((args) => {
        const newResizingWidth = args.get(1);
        if (newResizingWidth) {
            setParametersResizingWidth(newResizingWidth);
        }
    }, []);
    const { containerCellCoordinates } = useBeeTableCoordinates();
    const { isActive } = useBeeTableSelectableCellRef((_a = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.rowIndex) !== null && _a !== void 0 ? _a : 0, (_b = containerCellCoordinates === null || containerCellCoordinates === void 0 ? void 0 : containerCellCoordinates.columnIndex) !== null && _b !== void 0 ? _b : 0, undefined);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject();
        }
    }, [beeGwtService, isActive]);
    const { nestedExpressionContainerValue, onColumnResizingWidthChange: onColumnResizingWidthChange2 } = useNestedExpressionContainerWithNestedExpressions(useMemo(() => {
        var _a;
        const nestedExpressions = ((_a = invocationExpression.binding) !== null && _a !== void 0 ? _a : []).map((b) => { var _a; return (_a = b.expression) !== null && _a !== void 0 ? _a : undefined; });
        const maxNestedExpressionTotalMinWidth = Math.max(...nestedExpressions.map((e) => getExpressionTotalMinWidth(0, e, widthsById)), INVOCATION_ARGUMENT_EXPRESSION_MIN_WIDTH);
        return {
            nestedExpressions: nestedExpressions,
            fixedColumnActualWidth: parametersWidth,
            fixedColumnResizingWidth: parametersResizingWidth,
            fixedColumnMinWidth: INVOCATION_PARAMETER_MIN_WIDTH,
            nestedExpressionMinWidth: maxNestedExpressionTotalMinWidth,
            extraWidth: INVOCATION_EXTRA_WIDTH,
            expression: invocationExpression,
            flexibleColumnIndex: 2,
            widthsById: widthsById,
        };
    }, [invocationExpression, parametersWidth, parametersResizingWidth, widthsById]));
    const onColumnResizingWidthChange = useCallback((args) => {
        onColumnResizingWidthChange2 === null || onColumnResizingWidthChange2 === void 0 ? void 0 : onColumnResizingWidthChange2(args);
        onColumnResizingWidthChange1(args);
    }, [onColumnResizingWidthChange1, onColumnResizingWidthChange2]);
    const beeTableRows = useMemo(() => {
        var _a;
        return ((_a = invocationExpression.binding) !== null && _a !== void 0 ? _a : []).map((b, i) => ({
            variable: b.parameter,
            expression: b.expression,
            index: i,
        }));
    }, [invocationExpression.binding]);
    const invocationId = useMemo(() => { var _a, _b; return (_b = (_a = invocationExpression.expression) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : "functionName"; }, [invocationExpression.expression]);
    const beeTableColumns = useMemo(() => {
        var _a, _b, _c, _d, _e;
        return [
            {
                accessor: expressionHolderId,
                label: (_a = invocationExpression["@_label"]) !== null && _a !== void 0 ? _a : DEFAULT_EXPRESSION_VARIABLE_NAME,
                dataType: (_b = invocationExpression["@_typeRef"]) !== null && _b !== void 0 ? _b : DmnBuiltInDataType.Undefined,
                isRowIndexColumn: false,
                width: undefined,
                columns: [
                    {
                        accessor: invocationId,
                        label: ((_c = invocationExpression.expression) === null || _c === void 0 ? void 0 : _c.__$$element) === "literalExpression"
                            ? (_e = (_d = invocationExpression.expression.text) === null || _d === void 0 ? void 0 : _d.__$$text) !== null && _e !== void 0 ? _e : "Function name"
                            : "Function name",
                        isRowIndexColumn: false,
                        isInlineEditable: true,
                        dataType: undefined,
                        width: undefined,
                        groupType: "invokedFunctionName",
                        columns: [
                            {
                                accessor: "parameter",
                                label: "parameter",
                                isRowIndexColumn: false,
                                dataType: DmnBuiltInDataType.Undefined,
                                isWidthPinned: true,
                                minWidth: CONTEXT_ENTRY_VARIABLE_MIN_WIDTH,
                                width: parametersWidth,
                                setWidth: setParametersWidth,
                            },
                            {
                                accessor: "expression",
                                label: "expression",
                                isRowIndexColumn: false,
                                dataType: DmnBuiltInDataType.Undefined,
                                minWidth: INVOCATION_ARGUMENT_EXPRESSION_MIN_WIDTH,
                                width: undefined,
                            },
                        ],
                    },
                ],
            },
        ];
    }, [expressionHolderId, invocationExpression, parametersWidth, invocationId, setParametersWidth]);
    const onColumnUpdates = useCallback((columnUpdates) => {
        var _a, _b;
        for (const u of columnUpdates) {
            if (u.column.originalId === id) {
                setExpression({
                    setExpressionAction: (prev) => ({
                        ...prev,
                        "@_id": prev["@_id"],
                        name: u.name,
                    }),
                    expressionChangedArgs: {
                        action: Action.VariableChanged,
                        variableUuid: expressionHolderId,
                        nameChange: { from: (_a = invocationExpression["@_label"]) !== null && _a !== void 0 ? _a : "", to: u.name },
                    },
                });
            }
            else if (u.column.originalId === invocationId) {
                setExpression({
                    setExpressionAction: (prev) => {
                        var _a, _b;
                        const ret = {
                            ...prev,
                            expression: {
                                ...prev.expression,
                                "@_id": (_b = (_a = prev.expression) === null || _a === void 0 ? void 0 : _a["@_id"]) !== null && _b !== void 0 ? _b : generateUuid(),
                                __$$element: "literalExpression",
                                text: {
                                    __$$text: u.name,
                                },
                            },
                        };
                        return ret;
                    },
                    expressionChangedArgs: {
                        action: Action.VariableChanged,
                        variableUuid: expressionHolderId,
                        nameChange: { from: (_b = invocationExpression["@_label"]) !== null && _b !== void 0 ? _b : "", to: u.name },
                    },
                });
            }
            else {
                setExpression({
                    setExpressionAction: (prev) => {
                        var _a;
                        const ret = {
                            ...prev,
                            "@_id": (_a = prev["@_id"]) !== null && _a !== void 0 ? _a : generateUuid(),
                            "@_typeRef": u.typeRef,
                            "@_label": u.name,
                        };
                        return ret;
                    },
                    expressionChangedArgs: { action: Action.ExpressionCreated },
                });
            }
        }
    }, [id, invocationId, setExpression, expressionHolderId, invocationExpression]);
    const headerVisibility = useMemo(() => (isNested ? BeeTableHeaderVisibility.SecondToLastLevel : BeeTableHeaderVisibility.AllLevels), [isNested]);
    const getRowKey = useCallback((row) => {
        return row.id;
    }, []);
    const updateParameter = useCallback((index, { expression, variable }) => {
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newArgumentEntries = [...((_a = prev.binding) !== null && _a !== void 0 ? _a : [])];
                newArgumentEntries[index] = {
                    parameter: variable,
                    expression: expression,
                };
                const ret = {
                    ...prev,
                    binding: newArgumentEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.InvocationParametersChanged },
        });
    }, [setExpression]);
    const cellComponentByColumnAccessor = useMemo(() => ({
        parameter: (props) => _jsx(ExpressionVariableCell, { ...props, onExpressionWithVariableUpdated: updateParameter }),
        expression: (props) => _jsx(ArgumentEntryExpressionCell, { ...props, parentElementId: parentElementId }),
    }), [parentElementId, updateParameter]);
    const beeTableOperationConfig = useMemo(() => {
        return [
            {
                group: i18n.parameters,
                items: [
                    { name: i18n.rowOperations.reset, type: BeeTableOperation.RowReset },
                    { name: i18n.rowOperations.insertAbove, type: BeeTableOperation.RowInsertAbove },
                    { name: i18n.rowOperations.insertBelow, type: BeeTableOperation.RowInsertBelow },
                    { name: i18n.insert, type: BeeTableOperation.RowInsertN },
                    { name: i18n.rowOperations.delete, type: BeeTableOperation.RowDelete },
                ],
            },
            {
                group: i18n.terms.selection.toUpperCase(),
                items: [
                    { name: i18n.terms.copy, type: BeeTableOperation.SelectionCopy },
                    { name: i18n.terms.cut, type: BeeTableOperation.SelectionCut },
                    { name: i18n.terms.paste, type: BeeTableOperation.SelectionPaste },
                    { name: i18n.terms.reset, type: BeeTableOperation.SelectionReset },
                ],
            },
        ];
    }, [i18n]);
    const getDefaultArgumentEntry = useCallback((name) => {
        var _a;
        return {
            parameter: {
                "@_id": generateUuid(),
                "@_typeRef": undefined,
                "@_name": name ||
                    getNextAvailablePrefixedName(((_a = invocationExpression.binding) !== null && _a !== void 0 ? _a : []).map((e) => e.parameter["@_name"]), "p"),
            },
            expression: undefined,
        };
    }, [invocationExpression.binding]);
    const onRowAdded = useCallback((args) => {
        var _a;
        const newEntries = [];
        const names = ((_a = invocationExpression.binding) !== null && _a !== void 0 ? _a : []).map((e) => e.parameter["@_name"]);
        for (let i = 0; i < args.rowsCount; i++) {
            const name = getNextAvailablePrefixedName(names, "p");
            names.push(name);
            newEntries.push(getDefaultArgumentEntry(name));
        }
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newArgumentEntries = [...((_a = prev.binding) !== null && _a !== void 0 ? _a : [])];
                for (const newEntry of newEntries) {
                    newArgumentEntries.splice(args.beforeIndex, 0, newEntry);
                }
                const ret = {
                    ...prev,
                    binding: newArgumentEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowsAdded, rowIndex: args.beforeIndex, rowsCount: args.rowsCount },
        });
    }, [getDefaultArgumentEntry, invocationExpression.binding, setExpression]);
    const onRowDeleted = useCallback((args) => {
        let oldExpression;
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newArgumentEntries = [...((_a = prev.binding) !== null && _a !== void 0 ? _a : [])];
                oldExpression = newArgumentEntries[args.rowIndex].expression;
                newArgumentEntries.splice(args.rowIndex, 1);
                const ret = {
                    ...prev,
                    binding: newArgumentEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowRemoved, rowIndex: args.rowIndex },
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [setExpression, setWidthsById]);
    const onRowReset = useCallback((args) => {
        let oldExpression;
        setExpression({
            setExpressionAction: (prev) => {
                var _a;
                const newArgumentEntries = [...((_a = prev.binding) !== null && _a !== void 0 ? _a : [])];
                oldExpression = newArgumentEntries[args.rowIndex].expression;
                const defaultArgumentEntry = getDefaultArgumentEntry(newArgumentEntries[args.rowIndex].parameter["@_name"]);
                newArgumentEntries.splice(args.rowIndex, 1, defaultArgumentEntry);
                const ret = {
                    ...prev,
                    binding: newArgumentEntries,
                };
                return ret;
            },
            expressionChangedArgs: { action: Action.RowReset, rowIndex: args.rowIndex },
        });
        setWidthsById(({ newMap }) => {
            for (const id of findAllIdsDeep(oldExpression)) {
                newMap.delete(id);
            }
        });
    }, [getDefaultArgumentEntry, setExpression, setWidthsById]);
    const allowedOperations = useCallback((conditions) => {
        if (!conditions.selection.selectionStart || !conditions.selection.selectionEnd) {
            return [];
        }
        return [
            BeeTableOperation.SelectionCopy,
            ...(conditions.selection.selectionStart.rowIndex >= 0
                ? [
                    BeeTableOperation.RowInsertAbove,
                    BeeTableOperation.RowInsertBelow,
                    BeeTableOperation.RowInsertN,
                    ...(beeTableRows.length > 1 ? [BeeTableOperation.RowDelete] : []),
                    BeeTableOperation.RowReset,
                ]
                : []),
        ];
    }, [beeTableRows.length]);
    return (_jsx(NestedExpressionContainerContext.Provider, { value: nestedExpressionContainerValue, children: _jsx("div", { className: `invocation-expression ${id}`, children: _jsx(BeeTable, { isReadOnly: isReadOnly, isEditableHeader: !isReadOnly, resizerStopBehavior: ResizerStopBehavior.SET_WIDTH_WHEN_SMALLER, tableId: id, headerLevelCountForAppendingRowIndexColumn: 2, headerVisibility: headerVisibility, skipLastHeaderGroup: true, cellComponentByColumnAccessor: cellComponentByColumnAccessor, columns: beeTableColumns, rows: beeTableRows, onColumnUpdates: onColumnUpdates, onColumnResizingWidthChange: onColumnResizingWidthChange, operationConfig: beeTableOperationConfig, allowedOperations: allowedOperations, getRowKey: getRowKey, onRowAdded: onRowAdded, onRowReset: onRowReset, onRowDeleted: onRowDeleted, shouldRenderRowIndexColumn: false, shouldShowRowsInlineControls: true, shouldShowColumnsInlineControls: false }) }) }));
}
//# sourceMappingURL=InvocationExpression.js.map