import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useMemo } from "react";
import { generateUuid } from "../../api";
import { NestedExpressionDispatchContextProvider, useBoxedExpressionEditorDispatch, } from "../../BoxedExpressionEditorContext";
import { ExpressionContainer } from "../ExpressionDefinitionRoot/ExpressionContainer";
export function IteratorExpressionCell({ rowIndex, columnIndex, parentElementId, iteratorClause, }) {
    const { setExpression } = useBoxedExpressionEditorDispatch();
    const onSetExpression = useCallback(({ getNewExpression, expressionChangedArgs }) => {
        setExpression({
            setExpressionAction: (prev) => {
                switch (rowIndex) {
                    case 1:
                        return {
                            ...prev,
                            in: {
                                "@_id": generateUuid(),
                                expression: getNewExpression(prev.in.expression),
                            },
                        };
                    case 2:
                    default:
                        if (prev.__$$element === "for") {
                            return {
                                ...prev,
                                return: {
                                    "@_id": generateUuid(),
                                    expression: getNewExpression(prev.return.expression),
                                },
                            };
                        }
                        else {
                            return {
                                ...prev,
                                satisfies: {
                                    "@_id": generateUuid(),
                                    expression: getNewExpression(prev.satisfies.expression),
                                },
                            };
                        }
                }
            },
            expressionChangedArgs,
        });
    }, [rowIndex, setExpression]);
    const currentExpression = useMemo(() => {
        var _a;
        if (typeof iteratorClause.child !== "string") {
            return (_a = iteratorClause.child) === null || _a === void 0 ? void 0 : _a.expression;
        }
    }, [iteratorClause.child]);
    return (_jsx(NestedExpressionDispatchContextProvider, { onSetExpression: onSetExpression, children: _jsx(ExpressionContainer, { expression: currentExpression, isResetSupported: true, isNested: true, rowIndex: rowIndex, columnIndex: columnIndex, parentElementId: parentElementId, parentElementTypeRef: undefined }) }));
}
//# sourceMappingURL=IteratorExpressionCell.js.map