import * as React from "react";
import * as ReactTable from "react-table";
import { BeeTableProps } from "../../api";
import { ResizingWidth } from "../../resizing/ResizingWidthsContext";
import { BeeTableResizingRef } from "../../resizing/BeeTableResizableColumnsContext";
import "./BeeTable.css";
export declare function getColumnsAtLastLevel<R extends ReactTable.Column<any> | ReactTable.ColumnInstance<any>>(columns: R[], depth?: number): R[];
export type BeeTableSelectionRef = {
    setActiveCellEditing: (isEditing: boolean) => void;
};
export declare function BeeTableInternal<R extends object>({ selectionRef, tableId, additionalRow, editColumnLabel, isEditableHeader, onCellUpdates, onColumnUpdates, onRowAdded, onRowDuplicated, onRowReset, onRowDeleted, onColumnAdded, onColumnDeleted, onHeaderClick, onHeaderKeyUp, onDataCellClick, onDataCellKeyUp, controllerCell, cellComponentByColumnAccessor, rows, columns, operationConfig, allowedOperations, headerVisibility, headerLevelCountForAppendingRowIndexColumn, skipLastHeaderGroup, getRowKey, getColumnKey, isReadOnly, enableKeyboardNavigation, shouldRenderRowIndexColumn, shouldShowRowsInlineControls, shouldShowColumnsInlineControls, resizerStopBehavior, lastColumnMinWidth, rowWrapper, supportsEvaluationHitsCount, }: BeeTableProps<R> & {
    selectionRef?: React.RefObject<BeeTableSelectionRef>;
}): JSX.Element;
export type BeeTableRef = BeeTableResizingRef & BeeTableSelectionRef;
export type ForwardRefBeeTableProps<R extends object> = BeeTableProps<R> & {
    forwardRef?: React.Ref<BeeTableRef | null>;
} & {
    onColumnResizingWidthChange?: (args: Map<number, ResizingWidth | undefined>) => void;
};
export declare const BeeTable: <R extends object>({ forwardRef, onColumnResizingWidthChange, ...props }: ForwardRefBeeTableProps<R>) => JSX.Element;
//# sourceMappingURL=BeeTable.d.ts.map