import { jsx as _jsx } from "react/jsx-runtime";
import { useCallback, useEffect } from "react";
import { BeeTableEditableCellContent } from "./BeeTableEditableCellContent";
import { useBeeTableSelectableCellRef } from "../../selection/BeeTableSelectionContext";
import { useBoxedExpressionEditor } from "../../BoxedExpressionEditorContext";
export function BeeTableDefaultCell({ cellProps, onCellUpdates, isReadOnly, columnIndex, setEditing, navigateHorizontally, navigateVertically, }) {
    var _a, _b;
    const onCellChanged = useCallback((value) => {
        onCellUpdates === null || onCellUpdates === void 0 ? void 0 : onCellUpdates([
            {
                value,
                row: cellProps.row.original,
                rowIndex: cellProps.row.index,
                column: cellProps.column,
                columnIndex: columnIndex - 1,
            },
        ]);
    }, [cellProps.column, cellProps.row.index, cellProps.row.original, columnIndex, onCellUpdates]);
    const getValue = useCallback(() => {
        return typeof cellProps.value === "string" ? cellProps.value : cellProps.value.content;
    }, [cellProps.value]);
    const { isActive, isEditing } = useBeeTableSelectableCellRef(cellProps.row.index, columnIndex, onCellChanged, getValue);
    const { beeGwtService } = useBoxedExpressionEditor();
    useEffect(() => {
        if (isActive) {
            const column = cellProps.column.id;
            const cell = cellProps.row.values[column];
            beeGwtService === null || beeGwtService === void 0 ? void 0 : beeGwtService.selectObject(cell ? cell.id : "");
        }
    }, [beeGwtService, cellProps.column.id, cellProps.columns, cellProps.row.values, isActive]);
    return (_jsx(BeeTableEditableCellContent, { isEditing: isEditing, isActive: isActive, setEditing: setEditing, onChange: onCellChanged, value: typeof cellProps.value === "string" ? cellProps.value : (_a = cellProps.value) === null || _a === void 0 ? void 0 : _a.content, isReadOnly: isReadOnly, onFeelEnterKeyDown: navigateVertically, onFeelTabKeyDown: navigateHorizontally, expressionId: typeof cellProps.value === "string" ? "" : (_b = cellProps.value) === null || _b === void 0 ? void 0 : _b.id }));
}
//# sourceMappingURL=BeeTableDefaultCell.js.map