import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useEffect, useMemo, useState } from "react";
import { Text } from "@patternfly/react-core/dist/js/components/Text";
import { TextInput } from "@patternfly/react-core/dist/js/components/TextInput";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import "./ModelTitle.scss";
import useOnclickOutside from "react-cool-onclickoutside";
import { Operation, useOperation } from "../../EditorScorecard";
import { HelpIcon } from "@patternfly/react-icons/dist/js/icons/help-icon";
export const MODEL_NAME_NOT_SET = "<Model Name not set>";
export const ModelTitle = (props) => {
    const { modelName, commitModelName } = props;
    const [isEditing, setEditing] = useState(false);
    const [title, setTitle] = useState("");
    const { activeOperation, setActiveOperation } = useOperation();
    const ref = useOnclickOutside((event) => onCommitAndClose(), {
        disabled: activeOperation !== Operation.UPDATE_NAME,
        eventTypes: ["click"],
    });
    useEffect(() => {
        setTitle(modelName);
    }, [modelName]);
    const onEdit = () => {
        if (commitModelName !== undefined) {
            setEditing(true);
            setActiveOperation(Operation.UPDATE_NAME);
        }
    };
    const onCommitAndClose = () => {
        onCommit();
        onCancel();
    };
    const onCommit = () => {
        if (commitModelName !== undefined) {
            commitModelName(title);
        }
    };
    const onCancel = () => {
        setEditing(false);
        setActiveOperation(Operation.NONE);
    };
    const isEditModeEnabled = useMemo(() => isEditing && activeOperation === Operation.UPDATE_NAME, [isEditing, activeOperation]);
    const modelTitleClassNames = useMemo(() => `${commitModelName !== undefined ? "modelTitle" : "modelTitle modelTitle--editing"} pf-c-title pf-m-2xl pf-c-form-control`, [commitModelName]);
    return (_jsx("div", { ref: ref, onKeyDown: (e) => {
            if (e.key === "Enter") {
                onEdit();
            }
            else if (e.key === "Escape") {
                setTitle(modelName);
                onCancel();
            }
        }, children: _jsx("div", { className: "modelTitle--full-width", children: _jsx(Form, { id: "modelTitle-form", onSubmit: (e) => {
                    e.stopPropagation();
                    e.preventDefault();
                }, children: _jsxs(Split, { hasGutter: true, className: "modelTitle--hide-overflow", children: [_jsx(SplitItem, { className: "modelTitle__icon", children: _jsx(Tooltip, { content: "The Model Name will be generated at runtime if not set.", children: _jsx("button", { "aria-label": "More info about Model Name", onClick: (e) => e.preventDefault(), className: "pf-c-form__group-label-help modelTitle__icon", children: _jsx(HelpIcon, { style: { color: "var(--pf-global--info-color--100)" } }) }) }) }), _jsx(SplitItem, { isFilled: true, className: "modelTitle--hide-overflow", children: _jsxs(FormGroup, { fieldId: "modelName", children: [!isEditModeEnabled && (_jsxs("div", { className: modelTitleClassNames, onClick: onEdit, "data-ouia-component-id": "model-name", children: [modelName.trim() !== "" && _jsx(Text, { className: "modelTitle__truncate", children: modelName }), modelName.trim() === "" && (_jsx(Text, { className: "modelTitle__truncate modelTitle__truncate--disabled", children: MODEL_NAME_NOT_SET }))] })), isEditModeEnabled && (_jsx(TextInput, { type: "text", id: "modelName", name: "modelName", "aria-describedby": "modelName ", className: `${modelTitleClassNames} modelTitle--editing`, autoFocus: true, value: title, placeholder: MODEL_NAME_NOT_SET, onChange: setTitle, onBlur: onCommitAndClose, ouiaId: "set-model-name" }))] }) })] }) }) }) }));
};
//# sourceMappingURL=ModelTitle.js.map