import { jsx as _jsx } from "react/jsx-runtime";
import { useState } from "react";
import { Select, SelectOption, SelectVariant, } from "@patternfly/react-core/dist/js/components/Select";
export const GenericSelector = (props) => {
    var _a;
    const [isOpen, setOpen] = useState(false);
    const onToggle = (_isOpen) => {
        setOpen(_isOpen);
    };
    const onSelect = (event, value) => {
        props.onSelect(value.toString());
        setOpen(!isOpen);
    };
    return (_jsx(Select, { id: props.id, className: "generic-selector ignore-onclickoutside", variant: SelectVariant.single, "aria-label": "Select", onToggle: onToggle, onSelect: onSelect, selections: props.selection, isOpen: isOpen, menuAppendTo: () => document.body, isDisabled: (_a = props.isDisabled) !== null && _a !== void 0 ? _a : false, ouiaId: props.id, children: props.items.map((item, index) => (_jsx(SelectOption, { value: typeof item === "string" ? item : item.value, isDisabled: typeof item === "string" ? false : item.isDisabled, "data-ouia-component-type": "select-option" }, index))) }));
};
//# sourceMappingURL=GenericSelector.js.map