import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from "react";
import { Split, SplitItem } from "@patternfly/react-core/dist/js/layouts/Split";
import { AttributeLabels, CharacteristicLabels, CharacteristicPredicateLabel, CharacteristicsTableAction, } from "../atoms";
import "./CharacteristicsTableRow.scss";
import { useValidationRegistry } from "../../../validation";
import { Builder } from "../../../paths";
export const CharacteristicsTableRow = (props) => {
    const { modelIndex, characteristicIndex, characteristic, areReasonCodesUsed, scorecardBaselineScore, dataFields, onEdit, onDelete, } = props;
    const handleEdit = (event) => {
        event.preventDefault();
        event.stopPropagation();
        onEdit();
    };
    return (_jsx("article", { id: `characteristic-n${characteristicIndex}`, "data-testid": `characteristic-n${characteristicIndex}`, className: "editable-item__inner", onClick: handleEdit, onKeyDown: (e) => {
            if (e.key === "Enter") {
                handleEdit(e);
            }
        }, "data-ouia-component-type": "characteristic-item", tabIndex: 0, children: _jsxs(Split, { hasGutter: true, style: { height: "100%" }, children: [_jsx(SplitItem, { children: _jsx("strong", { children: characteristic.characteristic.name }) }), _jsxs(SplitItem, { isFilled: true, children: [_jsx(CharacteristicLabels, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, activeCharacteristic: characteristic.characteristic, areReasonCodesUsed: areReasonCodesUsed, scorecardBaselineScore: scorecardBaselineScore }), _jsx(CharacteristicAttributesList, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic.characteristic, areReasonCodesUsed: areReasonCodesUsed, dataFields: dataFields })] }), _jsx(SplitItem, { children: _jsx(CharacteristicsTableAction, { index: characteristicIndex, onDelete: onDelete }) })] }) }));
};
const CharacteristicAttributesList = (props) => {
    const { modelIndex, characteristicIndex, characteristic, areReasonCodesUsed, dataFields } = props;
    const { validationRegistry } = useValidationRegistry();
    const validations = useCallback((attributeIndex) => validationRegistry.get(Builder()
        .forModel(modelIndex)
        .forCharacteristics()
        .forCharacteristic(characteristicIndex)
        .forAttribute(attributeIndex)
        .forPredicate()
        .build()), [modelIndex, characteristicIndex, characteristic]);
    return (_jsx("ul", { children: characteristic.Attribute.map((item, index) => (_jsxs("li", { children: [CharacteristicPredicateLabel(item.predicate, dataFields, validations(index)), _jsx(AttributeLabels, { modelIndex: modelIndex, characteristicIndex: characteristicIndex, characteristic: characteristic, activeAttributeIndex: index, activeAttribute: item, areReasonCodesUsed: areReasonCodesUsed, characteristicReasonCode: characteristic.reasonCode })] }, index))) }));
};
//# sourceMappingURL=CharacteristicsTableRow.js.map