import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback, useMemo, useState } from "react";
import { PageSection, PageSectionVariants } from "@patternfly/react-core/dist/js/components/Page";
import { Gallery, GalleryItem } from "@patternfly/react-core/dist/js/layouts/Gallery";
import { EmptyStateNoModels } from "../organisms";
import { v4 as uuid } from "uuid";
import { useSelector } from "react-redux";
import { getModelName, getModelType, isSupportedModelType } from "../../..";
import { LandingPageHeader, LandingPageToolbar, ModelCard } from "../molecules";
import { Actions } from "../../../reducers";
import { useHistory } from "react-router";
import { useBatchDispatch, useHistoryService } from "../../../history";
export const LandingPage = (props) => {
    const history = useHistory();
    const { service, getCurrentState } = useHistoryService();
    const dispatch = useBatchDispatch(service, getCurrentState);
    const [filter, setFilter] = useState("");
    const [showUnsupportedModels, setShowUnsupportedModels] = useState(true);
    const models = useSelector((state) => state.models);
    const hasUnsupportedModels = useMemo(() => (models !== null && models !== void 0 ? models : []).find((model) => !isSupportedModelType(model)) !== undefined, [models]);
    const filterModels = useCallback(() => {
        const _lowerCaseFilter = filter.toLowerCase();
        const _filteredModels = models === null || models === void 0 ? void 0 : models.filter((_model) => {
            const _modelName = getModelName(_model);
            const _isSupportedModelType = isSupportedModelType(_model);
            const _nameMatch = _modelName === undefined || _modelName.toLowerCase().includes(_lowerCaseFilter);
            const _supportMatch = showUnsupportedModels || _isSupportedModelType;
            return _nameMatch && _supportMatch;
        });
        return _filteredModels !== null && _filteredModels !== void 0 ? _filteredModels : [];
    }, [filter, showUnsupportedModels, models]);
    const filteredModels = useMemo(() => filterModels(), [filter, showUnsupportedModels, models]);
    const goToModel = useCallback((index) => {
        history.push({
            pathname: "editor/" + index,
        });
    }, [history]);
    const onDelete = useCallback((index, modelName) => {
        dispatch({
            type: Actions.DeleteModel,
            payload: {
                modelIndex: index,
            },
        });
    }, []);
    return (_jsxs("div", { "data-testid": "landing-page", children: [_jsxs(PageSection, { variant: PageSectionVariants.light, children: [_jsx(LandingPageHeader, { title: props.path }), _jsx(LandingPageToolbar, { onFilter: setFilter, hasUnsupportedModels: hasUnsupportedModels, showUnsupportedModels: showUnsupportedModels, onShowUnsupportedModels: setShowUnsupportedModels })] }), _jsx(PageSection, { isFilled: true, children: _jsxs("section", { children: [filteredModels.length > 0 && (_jsx(Gallery, { hasGutter: true, children: filteredModels.map((model) => {
                                const index = models === null || models === void 0 ? void 0 : models.indexOf(model);
                                const modelName = getModelName(model);
                                const modelType = getModelType(model);
                                return (_jsx(GalleryItem, { "data-testid": "landing-page__model-card", children: _jsx(ModelCard, { index: index, modelName: modelName, modelType: modelType, onClick: goToModel, onDelete: (_index) => onDelete(_index, modelName) }) }, uuid()));
                            }) })), filteredModels.length === 0 && (_jsx(EmptyStateNoModels, { createModel: () => {
                            } }))] }) })] }));
};
//# sourceMappingURL=LandingPage.js.map