import { Actions } from "./Actions";
import { Scorecard } from "@kie-tools/pmml-editor-marshaller";
import { ScorecardReducer } from "./ScorecardReducer";
import { DelegatingModelReducer } from "./DelegatingModelReducer";
import mergeReducers from "combine-reducer";
import { CharacteristicsReducer } from "./CharacteristicsReducer";
import { CharacteristicReducer } from "./CharacteristicReducer";
import { OutputFieldReducer } from "./OutputFieldReducer";
import { OutputReducer } from "./OutputReducer";
import { MiningSchemaReducer } from "./MiningSchemaReducer";
import { MiningSchemaFieldReducer } from "./MiningSchemaFieldReducer";
import { Builder } from "../paths";
export const ModelReducer = (historyService, validationRegistry) => {
    const scorecardReducer = mergeReducers(ScorecardReducer(historyService, validationRegistry), {
        MiningSchema: mergeReducers(MiningSchemaReducer(historyService, validationRegistry), {
            MiningField: MiningSchemaFieldReducer(historyService, validationRegistry),
        }),
        Output: mergeReducers(OutputReducer(historyService, validationRegistry), {
            OutputField: OutputFieldReducer(historyService, validationRegistry),
        }),
        Characteristics: mergeReducers(CharacteristicsReducer(historyService), {
            Characteristic: CharacteristicReducer(historyService),
        }),
    });
    const delegate = DelegatingModelReducer(historyService, new Map([
        [
            "Scorecard",
            {
                reducer: scorecardReducer,
                factory: (data) => {
                    const model = new Scorecard(data);
                    model._type = "Scorecard";
                    return model;
                },
            },
        ],
    ]));
    return (state, action) => {
        switch (action.type) {
            case Actions.DeleteModel:
                historyService.batch(state, Builder().forModel().build(), (draft) => {
                    if (draft !== undefined) {
                        const modelIndex = action.payload.modelIndex;
                        if (modelIndex >= 0 && modelIndex < draft.length) {
                            draft.splice(modelIndex, 1);
                        }
                    }
                });
                return state;
        }
        return delegate(state, action);
    };
};
//# sourceMappingURL=ModelReducer.js.map