import "@patternfly/react-core/dist/styles/base.css";
import "reactflow/dist/style.css";
import * as React from "react";
import { PMML } from "@kie-tools/pmml-editor-marshaller";
import { DmnLatestModel, AllDmnMarshallers } from "@kie-tools/dmn-marshaller";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import "@kie-tools/dmn-marshaller/dist/kie-extensions";
import "./DmnEditor.css";
import { Commands } from "./commands/CommandsContextProvider";
import { JavaCodeCompletionService } from "@kie-tools/import-java-classes-component/dist/components/ImportJavaClasses/services";
export type DmnEditorRef = {
    reset: (mode: DmnLatestModel) => void;
    getDiagramSvg: () => Promise<string | undefined>;
    openBoxedExpressionEditor: (nodeId: string) => void;
    getCommands: () => Commands;
};
export type NodeEvaluationResults = {
    evaluationResult: EvaluationResult;
    evaluationHitsCountByRuleOrRowId: Map<string, number>;
};
export type EvaluationResult = "succeeded" | "failed" | "skipped";
export type EvaluationResultsByNodeId = Map<string, NodeEvaluationResults>;
export type ValidationMessages = Record<string, any>;
export type OnDmnModelChange = (model: Normalized<DmnLatestModel>) => void;
export type OnRequestToJumpToPath = (normalizedPosixPathRelativeToTheOpenFile: string) => void;
export type OnRequestToResolvePath = (normalizedPosixPathRelativeToTheOpenFile: string) => string;
export type OnRequestExternalModelsAvailableToInclude = () => Promise<string[]>;
export type OnRequestExternalModelByPath = (normalizedPosixPathRelativeToTheOpenFile: string) => Promise<ExternalModel | null>;
export type ExternalModelsIndex = Record<string, ExternalModel | undefined>;
export type ExternalModel = ({
    type: "dmn";
} & ExternalDmn) | ({
    type: "pmml";
} & ExternalPmml);
export type ExternalDmnsIndex = Map<string, ExternalDmn>;
export type ExternalDmn = {
    model: Normalized<DmnLatestModel>;
    normalizedPosixPathRelativeToTheOpenFile: string;
    svg: string;
};
export type ExternalPmmlsIndex = Map<string, ExternalPmml>;
export type ExternalPmml = {
    model: PMML;
    normalizedPosixPathRelativeToTheOpenFile: string;
};
export type DmnEditorProps = {
    model: DmnLatestModel;
    originalVersion?: AllDmnMarshallers["version"];
    onModelChange?: OnDmnModelChange;
    onRequestExternalModelByPath?: OnRequestExternalModelByPath;
    onRequestExternalModelsAvailableToInclude?: OnRequestExternalModelsAvailableToInclude;
    externalModelsByNamespace?: ExternalModelsIndex;
    evaluationResultsByNodeId?: EvaluationResultsByNodeId;
    validationMessages?: ValidationMessages;
    externalContextName?: string;
    externalContextDescription?: string;
    issueTrackerHref?: string;
    isEvaluationHighlightsSupported?: boolean;
    isReadOnly?: boolean;
    isImportDataTypesFromJavaClassesSupported?: boolean;
    javaCodeCompletionService?: JavaCodeCompletionService;
    onRequestToJumpToPath?: OnRequestToJumpToPath;
    onRequestToResolvePath?: OnRequestToResolvePath;
    onModelDebounceStateChanged?: (changed: boolean) => void;
    onOpenedBoxedExpressionEditorNodeChange?: (newOpenedNodeId: string | undefined) => void;
};
export declare const DmnEditorInternal: ({ model, originalVersion, onModelChange, onOpenedBoxedExpressionEditorNodeChange, onModelDebounceStateChanged, forwardRef, }: DmnEditorProps & {
    forwardRef?: React.Ref<DmnEditorRef>;
}) => JSX.Element;
export declare const DmnEditor: React.ForwardRefExoticComponent<DmnEditorProps & React.RefAttributes<DmnEditorRef>>;
export declare function usePrevious<T>(value: T): T;
export declare function useStateAsItWasBeforeConditionBecameTrue<T>(state: T, condition: boolean, set: (prev: T) => void): void;
//# sourceMappingURL=DmnEditor.d.ts.map