import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useContext, useRef } from "react";
const CommandsContext = React.createContext({});
export function useCommands() {
    return useContext(CommandsContext);
}
export function CommandsContextProvider(props) {
    const commandsRef = useRef({
        hideFromDrd: () => {
            throw new Error("DMN EDITOR: hideFromDrd command not implemented.");
        },
        toggleHierarchyHighlight: () => {
            throw new Error("DMN EDITOR: toggleHierarchyHighlight command not implemented.");
        },
        togglePropertiesPanel: () => {
            throw new Error("DMN EDITOR: togglePropertiesPanel command not implemented.");
        },
        createGroup: () => {
            throw new Error("DMN EDITOR: createGroup command not implemented.");
        },
        selectAll: () => {
            throw new Error("DMN EDITOR: selectAll command not implemented.");
        },
        paste: () => {
            throw new Error("DMN EDITOR: paste command not implemented.");
        },
        copy: () => {
            throw new Error("DMN EDITOR: copy command not implemented.");
        },
        cut: () => {
            throw new Error("DMN EDITOR: cut command not implemented.");
        },
        cancelAction: () => {
            throw new Error("DMN EDITOR: cancelAction command not implemented.");
        },
        focusOnSelection: () => {
            throw new Error("DMN EDITOR: focusOnSelection command not implemented.");
        },
        resetPosition: () => {
            throw new Error("DMN EDITOR: resetPosition command not implemented.");
        },
    });
    return _jsx(CommandsContext.Provider, { value: { commandsRef }, children: props.children });
}
//# sourceMappingURL=CommandsContextProvider.js.map