import { DmnBuiltInDataType } from "@kie-tools/boxed-expression-component/dist/api";
import { DMN15__tBusinessKnowledgeModel, DMN15__tDecision, DMN15__tDefinitions, DMN15__tItemDefinition } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { DataTypeIndex } from "./DataTypes";
import { KIE__tConstraintType } from "@kie-tools/dmn-marshaller/dist/schemas/kie-1_0/ts-gen/types";
export declare function findDataTypeById({ definitions, itemDefinitionId, allDataTypesById, }: {
    allDataTypesById: DataTypeIndex;
    itemDefinitionId: string;
    definitions: Normalized<DMN15__tDefinitions>;
}): {
    items: ({
        __?: undefined;
        "@_id"?: string;
        "@_label"?: string;
        description?: ({
            __$$text: string;
        } & {
            __$$text: string;
        }) | undefined;
        extensionElements?: ({
            __?: undefined;
        } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tItemDefinition__extensionElements) | undefined;
        "@_name": string;
        "@_typeLanguage"?: string;
        "@_isCollection"?: boolean;
        itemComponent?: (any & {
            "@_id": string;
        })[] | undefined;
        functionItem?: ({
            __?: undefined;
            "@_id"?: string;
            "@_label"?: string;
            description?: ({
                __$$text: string;
            } & {
                __$$text: string;
            }) | undefined;
            extensionElements?: ({
                __?: undefined;
            } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tFunctionItem__extensionElements) | undefined;
            "@_outputTypeRef"?: string;
            parameters?: ({
                __?: undefined;
                "@_id"?: string;
                "@_label"?: string;
                description?: ({
                    __$$text: string;
                } & {
                    __$$text: string;
                }) | undefined;
                extensionElements?: ({
                    __?: undefined;
                } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tInformationItem__extensionElements) | undefined;
                "@_name": string;
                "@_typeRef"?: string;
            } & {
                "@_id": string;
            })[] | undefined;
        } & {
            "@_id": string;
        }) | undefined;
        typeRef?: ({
            __$$text: string;
        } & {
            __$$text: string;
        }) | undefined;
        allowedValues?: ({
            __?: undefined;
            "@_id"?: string;
            "@_label"?: string;
            description?: ({
                __$$text: string;
            } & {
                __$$text: string;
            }) | undefined;
            extensionElements?: ({
                __?: undefined;
            } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tUnaryTests__extensionElements) | undefined;
            "@_typeRef"?: string;
            "@_expressionLanguage"?: string;
            text: {
                __$$text: string;
            } & {
                __$$text: string;
            };
            "@_kie:constraintType"?: KIE__tConstraintType;
        } & {
            "@_id": string;
        }) | undefined;
        typeConstraint?: ({
            __?: undefined;
            "@_id"?: string;
            "@_label"?: string;
            description?: ({
                __$$text: string;
            } & {
                __$$text: string;
            }) | undefined;
            extensionElements?: ({
                __?: undefined;
            } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tUnaryTests__extensionElements) | undefined;
            "@_typeRef"?: string;
            "@_expressionLanguage"?: string;
            text: {
                __$$text: string;
            } & {
                __$$text: string;
            };
            "@_kie:constraintType"?: KIE__tConstraintType;
        } & {
            "@_id": string;
        }) | undefined;
    } & {
        "@_id": string;
    })[];
    itemDefinition: {
        __?: undefined;
        "@_id"?: string;
        "@_label"?: string;
        description?: ({
            __$$text: string;
        } & {
            __$$text: string;
        }) | undefined;
        extensionElements?: ({
            __?: undefined;
        } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tItemDefinition__extensionElements) | undefined;
        "@_name": string;
        "@_typeLanguage"?: string;
        "@_isCollection"?: boolean;
        itemComponent?: (any & {
            "@_id": string;
        })[] | undefined;
        functionItem?: ({
            __?: undefined;
            "@_id"?: string;
            "@_label"?: string;
            description?: ({
                __$$text: string;
            } & {
                __$$text: string;
            }) | undefined;
            extensionElements?: ({
                __?: undefined;
            } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tFunctionItem__extensionElements) | undefined;
            "@_outputTypeRef"?: string;
            parameters?: ({
                __?: undefined;
                "@_id"?: string;
                "@_label"?: string;
                description?: ({
                    __$$text: string;
                } & {
                    __$$text: string;
                }) | undefined;
                extensionElements?: ({
                    __?: undefined;
                } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tInformationItem__extensionElements) | undefined;
                "@_name": string;
                "@_typeRef"?: string;
            } & {
                "@_id": string;
            })[] | undefined;
        } & {
            "@_id": string;
        }) | undefined;
        typeRef?: ({
            __$$text: string;
        } & {
            __$$text: string;
        }) | undefined;
        allowedValues?: ({
            __?: undefined;
            "@_id"?: string;
            "@_label"?: string;
            description?: ({
                __$$text: string;
            } & {
                __$$text: string;
            }) | undefined;
            extensionElements?: ({
                __?: undefined;
            } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tUnaryTests__extensionElements) | undefined;
            "@_typeRef"?: string;
            "@_expressionLanguage"?: string;
            text: {
                __$$text: string;
            } & {
                __$$text: string;
            };
            "@_kie:constraintType"?: KIE__tConstraintType;
        } & {
            "@_id": string;
        }) | undefined;
        typeConstraint?: ({
            __?: undefined;
            "@_id"?: string;
            "@_label"?: string;
            description?: ({
                __$$text: string;
            } & {
                __$$text: string;
            }) | undefined;
            extensionElements?: ({
                __?: undefined;
            } & import("@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types").DMN15__tUnaryTests__extensionElements) | undefined;
            "@_typeRef"?: string;
            "@_expressionLanguage"?: string;
            text: {
                __$$text: string;
            } & {
                __$$text: string;
            };
            "@_kie:constraintType"?: KIE__tConstraintType;
        } & {
            "@_id": string;
        }) | undefined;
    } & {
        "@_id": string;
    };
    index: number;
};
export declare function getNewItemDefinition(partial?: Partial<Normalized<DMN15__tItemDefinition>>): Normalized<DMN15__tItemDefinition>;
export declare function isCollection(itemDefinition: Normalized<DMN15__tItemDefinition>): boolean;
export declare function isStruct(itemDefinition: Normalized<DMN15__tItemDefinition>): boolean;
export declare const constrainableBuiltInFeelTypes: Map<DmnBuiltInDataType, KIE__tConstraintType[]>;
export declare function canHaveConstraints(itemDefinition: Normalized<DMN15__tItemDefinition>): boolean;
export declare function traverseItemDefinitions(items: Normalized<DMN15__tItemDefinition>[], consumer: (itemDefinition: Normalized<DMN15__tItemDefinition>) => void): void;
export type AllExpressions = NonNullable<Normalized<DMN15__tDecision>["expression"]>;
export type AllExpressionsWithoutTypes = Omit<AllExpressions, "__$$element">;
export type AllExpressionTypes = AllExpressions["__$$element"];
export declare function traverseTypeRefedInExpressionHolders(expressionHolder: (Normalized<DMN15__tDecision> & {
    __$$element: "decision";
}) | (Normalized<DMN15__tBusinessKnowledgeModel> & {
    __$$element: "businessKnowledgeModel";
}), consumer: (typed: {
    "@_typeRef"?: string;
}) => void): void;
export declare function traverseTypeRefedInExpressions(expression: AllExpressionsWithoutTypes | undefined, __$$element: AllExpressionTypes | undefined, consumer: (typed: {
    "@_typeRef"?: string;
}) => void): void;
export declare function traverseExpressionsInExpressionHolders(expressionHolder: (Normalized<DMN15__tDecision> & {
    __$$element: "decision";
}) | (Normalized<DMN15__tBusinessKnowledgeModel> & {
    __$$element: "businessKnowledgeModel";
}), consumer: (expression: AllExpressionsWithoutTypes | undefined, __$$element: AllExpressionTypes | undefined) => void): void;
export declare function traverseExpressions(expression: AllExpressionsWithoutTypes | undefined, __$$element: AllExpressionTypes | undefined, consumer: (expression: AllExpressionsWithoutTypes | undefined, __$$element: AllExpressionTypes | undefined) => void): void;
//# sourceMappingURL=DataTypeSpec.d.ts.map