import * as React from "react";
import * as RF from "reactflow";
import { DMNDI15__DMNEdge, DMNDI15__DMNShape } from "@kie-tools/dmn-marshaller/dist/schemas/dmn-1_5/ts-gen/types";
import { Normalized } from "@kie-tools/dmn-marshaller/dist/normalization/normalize";
import { DrgEdge } from "../graph/graph";
export type DmnDiagramEdgeData = {
    dmnEdge: (Normalized<DMNDI15__DMNEdge> & {
        index: number;
    }) | undefined;
    dmnObject: DrgEdge["dmnObject"];
    dmnShapeSource: Normalized<DMNDI15__DMNShape> | undefined;
    dmnShapeTarget: Normalized<DMNDI15__DMNShape> | undefined;
};
export declare const InformationRequirementPath: React.MemoExoticComponent<(_props: React.SVGProps<SVGPathElement> & {
    svgRef?: React.RefObject<SVGPathElement>;
}) => JSX.Element>;
export declare const KnowledgeRequirementPath: React.MemoExoticComponent<(__props: React.SVGProps<SVGPathElement> & {
    svgRef?: React.RefObject<SVGPathElement>;
}) => JSX.Element>;
export declare const AuthorityRequirementPath: React.MemoExoticComponent<(__props: React.SVGProps<SVGPathElement> & {
    centerToConnectionPoint: boolean | undefined;
} & {
    svgRef?: React.RefObject<SVGPathElement>;
}) => JSX.Element>;
export declare const AssociationPath: React.MemoExoticComponent<(__props: React.SVGProps<SVGPathElement> & {
    svgRef?: React.RefObject<SVGPathElement>;
}) => JSX.Element>;
export declare function useEdgeClassName(isConnecting: boolean, isDraggingWaypoint: boolean): "normal" | "dimmed" | "dragging-waypoint";
export declare const InformationRequirementEdge: React.MemoExoticComponent<(props: RF.EdgeProps<DmnDiagramEdgeData>) => JSX.Element>;
export declare const KnowledgeRequirementEdge: React.MemoExoticComponent<(props: RF.EdgeProps<DmnDiagramEdgeData>) => JSX.Element>;
export declare const AuthorityRequirementEdge: React.MemoExoticComponent<(props: RF.EdgeProps<DmnDiagramEdgeData>) => JSX.Element>;
export declare const AssociationEdge: React.MemoExoticComponent<(props: RF.EdgeProps<DmnDiagramEdgeData>) => JSX.Element>;
//# sourceMappingURL=Edges.d.ts.map