import { switchExpression } from "@kie-tools-core/switch-expression-ts";
import { snapShapeDimensions, snapShapePosition } from "../diagram/SnapGrid";
import { PositionalNodeHandleId } from "../diagram/connections/PositionalNodeHandles";
import { getHandlePosition } from "../diagram/maths/DmnMaths";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { addOrGetDrd } from "./addOrGetDrd";
import { DECISION_SERVICE_DIVIDER_LINE_PADDING } from "./updateDecisionServiceDividerLine";
export function resizeNode({ definitions, drdIndex, __readonly_dmnShapesByHref, __readonly_dmnObjectNamespace, __readonly_externalDmnsIndex, snapGrid, change, }) {
    var _a, _b, _c, _d, _e, _f;
    const edgeIndexesAlreadyUpdated = new Set();
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    const shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[change.shapeIndex];
    const shapeBounds = shape === null || shape === void 0 ? void 0 : shape["dc:Bounds"];
    if (!shapeBounds) {
        throw new Error("DMN MUTATION: Cannot resize non-existent shape bounds");
    }
    const limit = { x: 0, y: 0 };
    if (change.nodeType === NODE_TYPES.decisionService) {
        const externalDmn = __readonly_externalDmnsIndex.get(__readonly_dmnObjectNamespace !== null && __readonly_dmnObjectNamespace !== void 0 ? __readonly_dmnObjectNamespace : "");
        const ds = externalDmn === undefined
            ? definitions.drgElement[change.index]
            : externalDmn.model.definitions.drgElement[change.index];
        if (!ds) {
            throw new Error("DMN MUTATION: Cannot reposition divider line of non-existent Decision Service");
        }
        const dividerLineY = (_d = (_c = (_b = (_a = shape["dmndi:DMNDecisionServiceDividerLine"]) === null || _a === void 0 ? void 0 : _a["di:waypoint"]) === null || _b === void 0 ? void 0 : _b[0]) === null || _c === void 0 ? void 0 : _c["@_y"]) !== null && _d !== void 0 ? _d : shapeBounds["@_y"];
        limit.y = dividerLineY + DECISION_SERVICE_DIVIDER_LINE_PADDING;
        if (!change.isExternal) {
            (_e = ds.encapsulatedDecision) === null || _e === void 0 ? void 0 : _e.forEach((ed) => {
                const edShape = __readonly_dmnShapesByHref.get(ed["@_href"]);
                const dim = snapShapeDimensions(snapGrid, edShape, MIN_NODE_SIZES[NODE_TYPES.decision]({ snapGrid }));
                const pos = snapShapePosition(snapGrid, edShape);
                if (pos.x + dim.width > limit.x) {
                    limit.x = pos.x + dim.width;
                }
                if (pos.y + dim.height > limit.y) {
                    limit.y = pos.y + dim.height;
                }
            });
            (_f = ds.outputDecision) === null || _f === void 0 ? void 0 : _f.forEach((ed) => {
                const edShape = __readonly_dmnShapesByHref.get(ed["@_href"]);
                const dim = snapShapeDimensions(snapGrid, edShape, MIN_NODE_SIZES[NODE_TYPES.decision]({ snapGrid }));
                const pos = snapShapePosition(snapGrid, edShape);
                if (pos.x + dim.width > limit.x) {
                    limit.x = pos.x + dim.width;
                }
            });
        }
    }
    const snappedPosition = snapShapePosition(snapGrid, shape);
    const newDimensions = {
        width: Math.max(change.dimension["@_width"], limit.x - snappedPosition.x),
        height: Math.max(change.dimension["@_height"], limit.y - snappedPosition.y),
    };
    const deltaWidth = newDimensions.width - shapeBounds["@_width"];
    const deltaHeight = newDimensions.height - shapeBounds["@_height"];
    const offsetByPosition = (position) => {
        return switchExpression(position, {
            [PositionalNodeHandleId.Center]: { x: deltaWidth / 2, y: deltaHeight / 2 },
            [PositionalNodeHandleId.Top]: { x: deltaWidth / 2, y: 0 },
            [PositionalNodeHandleId.Right]: { x: deltaWidth, y: deltaHeight / 2 },
            [PositionalNodeHandleId.Bottom]: { x: deltaWidth / 2, y: deltaHeight },
            [PositionalNodeHandleId.Left]: { x: 0, y: deltaHeight / 2 },
        });
    };
    const offsetEdges = (args) => {
        for (const edgeIndex of args.edgeIndexes) {
            if (edgeIndexesAlreadyUpdated.has(edgeIndex)) {
                continue;
            }
            edgeIndexesAlreadyUpdated.add(edgeIndex);
            const edge = diagramElements[edgeIndex];
            if (!edge || !edge["di:waypoint"]) {
                throw new Error("DMN MUTATION: Cannot reposition non-existent edge");
            }
            const waypoint = switchExpression(args.waypointSelector, {
                first: edge["di:waypoint"][0],
                last: edge["di:waypoint"][edge["di:waypoint"].length - 1],
            });
            const offset = offsetByPosition(getHandlePosition({ shapeBounds, waypoint }).handlePosition);
            waypoint["@_x"] += offset.x;
            waypoint["@_y"] += offset.y;
        }
    };
    offsetEdges({ edgeIndexes: change.sourceEdgeIndexes, waypointSelector: "first" });
    offsetEdges({ edgeIndexes: change.targetEdgeIndexes, waypointSelector: "last" });
    shapeBounds["@_width"] = newDimensions.width;
    shapeBounds["@_height"] = newDimensions.height;
}
//# sourceMappingURL=resizeNode.js.map