import { addNamespaceToHref } from "@kie-tools/dmn-marshaller/dist/xml/xmlHrefs";
import { addOrGetDrd } from "./addOrGetDrd";
import { snapShapeDimensions, snapShapePosition } from "../diagram/SnapGrid";
import { MIN_NODE_SIZES } from "../diagram/nodes/DefaultSizes";
import { NODE_TYPES } from "../diagram/nodes/NodeTypes";
import { generateUuid } from "@kie-tools/boxed-expression-component/dist/api";
export const DECISION_SERVICE_DIVIDER_LINE_PADDING = 100;
export function updateDecisionServiceDividerLine({ definitions, drdIndex, __readonly_dmnShapesByHref, __readonly_dmnObjectNamespace, __readonly_externalDmnsIndex, shapeIndex, localYPosition, drgElementIndex, snapGrid, }) {
    var _a, _b, _c;
    const { diagramElements } = addOrGetDrd({ definitions, drdIndex });
    const shape = diagramElements === null || diagramElements === void 0 ? void 0 : diagramElements[shapeIndex];
    const shapeBounds = shape === null || shape === void 0 ? void 0 : shape["dc:Bounds"];
    if (!shapeBounds) {
        throw new Error("DMN MUTATION: Cannot reposition divider line of non-existent shape bounds");
    }
    const externalDmn = __readonly_externalDmnsIndex.get(__readonly_dmnObjectNamespace !== null && __readonly_dmnObjectNamespace !== void 0 ? __readonly_dmnObjectNamespace : "");
    const ds = externalDmn === undefined
        ? definitions.drgElement[drgElementIndex]
        : externalDmn.model.definitions.drgElement[drgElementIndex];
    if (!ds) {
        throw new Error("DMN MUTATION: Cannot reposition divider line of non-existent Decision Service");
    }
    const decisionMinSizes = MIN_NODE_SIZES[NODE_TYPES.decision]({ snapGrid });
    const decisionServiceMinSizes = MIN_NODE_SIZES[NODE_TYPES.decisionService]({ snapGrid });
    const snappedPosition = snapShapePosition(snapGrid, shape);
    const snappedDimensions = snapShapeDimensions(snapGrid, shape, decisionServiceMinSizes);
    const upperLimit = ((_a = ds.outputDecision) !== null && _a !== void 0 ? _a : []).reduce((acc, od) => {
        const href = __readonly_dmnObjectNamespace !== undefined
            ? addNamespaceToHref({
                href: od["@_href"],
                namespace: definitions["@_namespace"] === __readonly_dmnObjectNamespace ? undefined : __readonly_dmnObjectNamespace,
            })
            : od["@_href"];
        const v = snapShapePosition(snapGrid, __readonly_dmnShapesByHref.get(href)).y +
            snapShapeDimensions(snapGrid, __readonly_dmnShapesByHref.get(href), decisionMinSizes).height;
        return v > acc ? v : acc;
    }, snappedPosition.y + DECISION_SERVICE_DIVIDER_LINE_PADDING);
    const lowerLimit = ((_b = ds.encapsulatedDecision) !== null && _b !== void 0 ? _b : []).reduce((acc, ed) => {
        const href = __readonly_dmnObjectNamespace !== undefined
            ? addNamespaceToHref({
                href: ed["@_href"],
                namespace: definitions["@_namespace"] === __readonly_dmnObjectNamespace
                    ? undefined
                    : __readonly_dmnObjectNamespace,
            })
            : ed["@_href"];
        const v = snapShapePosition(snapGrid, __readonly_dmnShapesByHref.get(href)).y;
        return v < acc ? v : acc;
    }, snappedPosition.y + snappedDimensions.height - DECISION_SERVICE_DIVIDER_LINE_PADDING);
    const newDividerLineYPosition = Math.max(upperLimit, Math.min(snappedPosition.y + localYPosition, lowerLimit));
    (_c = shape["dmndi:DMNDecisionServiceDividerLine"]) !== null && _c !== void 0 ? _c : (shape["dmndi:DMNDecisionServiceDividerLine"] = getCentralizedDecisionServiceDividerLine(shapeBounds));
    shape["dmndi:DMNDecisionServiceDividerLine"]["di:waypoint"][0]["@_y"] = newDividerLineYPosition;
    shape["dmndi:DMNDecisionServiceDividerLine"]["di:waypoint"][1]["@_y"] = newDividerLineYPosition;
}
export function getCentralizedDecisionServiceDividerLine(bounds) {
    return {
        "@_id": generateUuid(),
        "di:waypoint": [
            { "@_x": bounds["@_x"], "@_y": bounds["@_y"] + bounds["@_height"] / 2 },
            {
                "@_x": bounds["@_x"] + bounds["@_height"],
                "@_y": bounds["@_y"] + bounds["@_height"] / 2,
            },
        ],
    };
}
//# sourceMappingURL=updateDecisionServiceDividerLine.js.map