import { jsx as _jsx } from "react/jsx-runtime";
import { useMemo } from "react";
import { InMemoryCache } from "apollo-cache-inmemory";
import { ApolloClient } from "apollo-client";
import { HttpLink } from "apollo-link-http";
import { WorkflowListContext } from "./WorkflowListContext";
import { WorkflowListGatewayApiImpl } from "./WorkflowListGatewayApi";
import { GraphQLWorkflowListQueries } from "./WorkflowListQueries";
export function WorkflowListContextProvider(props) {
    const { proxyEndpoint, dataIndexUrl } = props;
    const httpLink = useMemo(() => new HttpLink({
        uri: proxyEndpoint || dataIndexUrl,
        headers: {
            ...(proxyEndpoint ? { "Target-Url": dataIndexUrl } : {}),
        },
    }), [dataIndexUrl, proxyEndpoint]);
    const cache = useMemo(() => new InMemoryCache(), []);
    const apolloClient = useMemo(() => new ApolloClient({
        cache,
        link: httpLink,
    }), [cache, httpLink]);
    return (_jsx(WorkflowListContextProviderWithApolloClient, { apolloClient: apolloClient, children: props.children }));
}
export function WorkflowListContextProviderWithApolloClient(props) {
    const { apolloClient } = props;
    const gatewayApiImpl = useMemo(() => {
        return new WorkflowListGatewayApiImpl(new GraphQLWorkflowListQueries(apolloClient));
    }, [apolloClient]);
    return _jsx(WorkflowListContext.Provider, { value: gatewayApiImpl, children: props.children });
}
//# sourceMappingURL=WorkflowListContextProvider.js.map