import { jsx as _jsx, jsxs as _jsxs, Fragment as _Fragment } from "react/jsx-runtime";
import "./ImportJavaClassesWizardFirstStep.css";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { DataList, DataListCell, DataListCheck, DataListItem, DataListItemRow, } from "@patternfly/react-core/dist/js/components/DataList";
import { EmptyState, EmptyStateBody, EmptyStateIcon } from "@patternfly/react-core/dist/js/components/EmptyState";
import { SearchInput } from "@patternfly/react-core/dist/js/components/SearchInput";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import CubesIcon from "@patternfly/react-icons/dist/js/icons/cubes-icon";
import { useImportJavaClassesWizardI18n } from "../../i18n";
import { useCallback, useState } from "react";
export const ImportJavaClassesWizardFirstStep = ({ javaCodeCompletionService, onAddJavaClass, onRemoveJavaClass, selectedJavaClasses, }) => {
    const { i18n } = useImportJavaClassesWizardI18n();
    const [searchValue, setSearchValue] = useState("");
    const [retrievedJavaClassesNames, setRetrievedJavaClassesNames] = useState([]);
    const [isRequestLoading, setRequestLoading] = useState(false);
    const [requestTimer, setRequestTimer] = useState(undefined);
    const retrieveJavaClasses = useCallback((value) => {
        setRequestLoading(true);
        javaCodeCompletionService
            .getClasses(value)
            .then((javaCodeCompletionClasses) => {
            const retrievedClasses = javaCodeCompletionClasses.map((item) => item.fqcn);
            setRetrievedJavaClassesNames(retrievedClasses);
            setRequestLoading(false);
        })
            .catch((reason) => {
            setRetrievedJavaClassesNames([]);
            setRequestLoading(false);
            console.error(reason);
        });
    }, [javaCodeCompletionService]);
    const handleSearchValueChange = useCallback((event, value) => {
        setSearchValue(value);
        if (requestTimer) {
            clearTimeout(requestTimer);
        }
        if (value.length > 2) {
            setRequestTimer(global.setTimeout(() => {
                retrieveJavaClasses(value);
            }, 1000));
        }
        else {
            setRetrievedJavaClassesNames([]);
        }
    }, [retrieveJavaClasses, requestTimer]);
    const handleClearSearch = useCallback(() => {
        setSearchValue("");
        setRetrievedJavaClassesNames([]);
    }, []);
    const handleDataListCheckChange = useCallback((fullClassName) => {
        if (!selectedJavaClasses.map((javaClass) => javaClass.name).includes(fullClassName)) {
            onAddJavaClass(fullClassName);
        }
        else {
            onRemoveJavaClass(fullClassName);
        }
    }, [selectedJavaClasses, onAddJavaClass, onRemoveJavaClass]);
    const isDataListChecked = useCallback((fullClassName) => {
        if (selectedJavaClasses.map((javaClass) => javaClass.name).includes(fullClassName)) {
            return true;
        }
        else {
            return false;
        }
    }, [selectedJavaClasses]);
    const dataListClassesSet = [
        ...new Set(selectedJavaClasses.map((value) => value.name).concat(retrievedJavaClassesNames)),
    ];
    return (_jsxs(_Fragment, { children: [_jsx("div", { className: "fs-search-input", children: _jsx(Tooltip, { content: i18n.modalWizard.firstStep.input.tooltip, isVisible: searchValue.length < 3, children: _jsx(SearchInput, { autoFocus: true, onChange: handleSearchValueChange, onClear: handleClearSearch, placeholder: i18n.modalWizard.firstStep.input.placeholder, value: searchValue }) }) }), isRequestLoading ? (_jsx(Bullseye, { children: _jsx(Spinner, { isSVG: true }) })) : retrievedJavaClassesNames.length > 0 || selectedJavaClasses.length > 0 ? (_jsx(DataList, { "aria-label": "class-data-list", children: dataListClassesSet.map((value) => (_jsx(DataListItem, { name: value, children: _jsxs(DataListItemRow, { children: [_jsx(DataListCheck, { "aria-labelledby": value, checked: isDataListChecked(value), onChange: () => handleDataListCheckChange(value) }), _jsx(DataListCell, { children: _jsx("span", { id: value, children: value }) })] }) }, value))) })) : (_jsx(EmptyStep, { emptyStateBodyText: i18n.modalWizard.firstStep.emptyState.body, emptyStateTitleText: i18n.modalWizard.firstStep.emptyState.title }))] }));
};
const EmptyStep = ({ emptyStateBodyText, emptyStateTitleText, }) => {
    return (_jsxs(EmptyState, { children: [_jsx(EmptyStateIcon, { icon: CubesIcon }), _jsx(Title, { headingLevel: "h6", size: "md", children: emptyStateTitleText }), _jsx(EmptyStateBody, { children: emptyStateBodyText })] }));
};
//# sourceMappingURL=ImportJavaClassesWizardFirstStep.js.map