import { jsx as _jsx, Fragment as _Fragment } from "react/jsx-runtime";
import { Bullseye } from "@patternfly/react-core/dist/js/layouts/Bullseye";
import { Spinner } from "@patternfly/react-core/dist/js/components/Spinner";
import { useCallback, useEffect } from "react";
import { ImportJavaClassesWizardFieldListTable } from "./ImportJavaClassesWizardFieldListTable";
import { JavaField } from "./model/JavaField";
import { DMNSimpleType, JAVA_TO_DMN_MAP } from "./model/DMNSimpleType";
import { getJavaClassSimpleName } from "./model/JavaClassUtils";
export const ImportJavaClassesWizardSecondStep = ({ javaCodeCompletionService, onAddJavaClass, onSelectedJavaClassedFieldsLoaded, selectedJavaClasses, }) => {
    const accessorPrefixesList = ["get", "is"];
    const denyList = ["getClass()", "serialVersionUID"];
    const isGetterMethod = useCallback((accessorName) => {
        return accessorName.includes("()") && accessorPrefixesList.some((value) => accessorName.startsWith(value));
    }, []);
    const isMethod = useCallback((accessorName) => {
        return accessorName.includes("(") && accessorName.includes(")");
    }, []);
    const renameAccessorName = useCallback((originalName) => {
        if (isGetterMethod(originalName)) {
            const prefixIndex = accessorPrefixesList.findIndex((value) => originalName.startsWith(value));
            const name = originalName.substring(accessorPrefixesList[prefixIndex].length, originalName.lastIndexOf("("));
            return name.charAt(0).toLowerCase() + name.slice(1);
        }
        else {
            return originalName;
        }
    }, [isGetterMethod]);
    const generateJavaClassField = useCallback((name, type, javaClasses) => {
        let dmnTypeRef = JAVA_TO_DMN_MAP.get(getJavaClassSimpleName(type)) || DMNSimpleType.ANY;
        if (dmnTypeRef === DMNSimpleType.ANY && javaClasses.some((javaClass) => javaClass.name === type)) {
            dmnTypeRef = getJavaClassSimpleName(type);
        }
        return new JavaField(name, type, dmnTypeRef);
    }, []);
    const isInDenyList = useCallback((accessorName) => {
        return denyList.includes(accessorName);
    }, []);
    const loadJavaFields = useCallback((className) => {
        try {
            javaCodeCompletionService
                .getFields(className)
                .then((javaCodeCompletionFields) => {
                const retrievedFields = javaCodeCompletionFields
                    .filter((javaCodeCompletionField) => !isInDenyList(javaCodeCompletionField.accessor) &&
                    (!isMethod(javaCodeCompletionField.accessor) || isGetterMethod(javaCodeCompletionField.accessor)))
                    .map((javaCodeCompletionField) => generateJavaClassField(renameAccessorName(javaCodeCompletionField.accessor), javaCodeCompletionField.type, selectedJavaClasses));
                retrievedFields.sort((a, b) => (a.name < b.name ? -1 : 1));
                onSelectedJavaClassedFieldsLoaded(className, retrievedFields);
            })
                .catch((reason) => {
                console.error(reason);
            });
        }
        catch (error) {
            console.error(error);
        }
    }, [
        generateJavaClassField,
        javaCodeCompletionService,
        onSelectedJavaClassedFieldsLoaded,
        selectedJavaClasses,
        isGetterMethod,
        isMethod,
        renameAccessorName,
    ]);
    useEffect(() => selectedJavaClasses
        .filter((javaClass) => !javaClass.fieldsLoaded)
        .forEach((javaClass) => loadJavaFields(javaClass.name)), [selectedJavaClasses, loadJavaFields]);
    return (_jsx(_Fragment, { children: selectedJavaClasses.some((javaClass) => !javaClass.fieldsLoaded) ? (_jsx(Bullseye, { children: _jsx(Spinner, { isSVG: true }) })) : (_jsx(ImportJavaClassesWizardFieldListTable, { selectedJavaClassFields: selectedJavaClasses, loadJavaClass: onAddJavaClass })) }));
};
//# sourceMappingURL=ImportJavaClassesWizardSecondStep.js.map