import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { TextVariants, Text } from "@patternfly/react-core/dist/js/components/Text";
import { Card, CardBody, CardHeaderMain, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { FormGroup, Form } from "@patternfly/react-core/dist/js/components/Form";
import Moment from "react-moment";
const CustomDashboardCard = ({ customDashboardData, driver, ouiaId, ouiaSafe, }) => {
    const handleCardClick = () => {
        driver.openDashboard(customDashboardData);
    };
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId, "customDashboard-card", ouiaSafe), isSelectable: true, onClick: handleCardClick, "data-testid": "card", children: [_jsx(CardHeader, { children: _jsx(CardHeaderMain, { children: "Empty" }) }), _jsx(CardHeader, { children: _jsx(Text, { component: TextVariants.h1, className: "pf-u-font-weight-bold", children: customDashboardData.name }) }), _jsx(CardBody, { children: _jsx("div", { className: "pf-u-mt-md", children: _jsxs(Form, { children: [_jsx(FormGroup, { label: "Path", fieldId: "path", children: _jsx(Text, { component: TextVariants.p, children: customDashboardData.path }) }), _jsx(FormGroup, { label: "LastModified", fieldId: "lastModified", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: customDashboardData.lastModified }) }) })] }) }) })] }));
};
export default CustomDashboardCard;
//# sourceMappingURL=CustomDashboardCard.js.map