import { EditorTheme } from "@kie-tools-core/editor/dist/api";
import { editor } from "monaco-editor";
export interface FormEditorEditorApi {
    editor: editor.IStandaloneCodeEditor | undefined;
    show: (container: HTMLDivElement, theme?: EditorTheme) => editor.IStandaloneCodeEditor;
    undo: () => void;
    redo: () => void;
    getContent: () => string;
    setContent: (content: string) => void;
    setTheme: (theme: EditorTheme) => void;
    forceRedraw: () => void;
    dispose: () => void;
    doResize: () => void;
}
export declare enum FormEditorEditorOperation {
    UNDO = 0,
    REDO = 1,
    EDIT = 2
}
export interface FormEditorEditorInstance {
    instance: editor.IStandaloneCodeEditor;
}
export declare class FormEditorEditorController implements FormEditorEditorApi {
    private readonly onContentChange;
    private readonly language;
    private readonly isReadOnly;
    private readonly model;
    editor: editor.IStandaloneCodeEditor | undefined;
    constructor(content: string, onContentChange: (args: {
        content: string;
        operation: FormEditorEditorOperation;
    }) => void, language: string | undefined, isReadOnly: boolean);
    redo(): void;
    undo(): void;
    setTheme(theme: EditorTheme): void;
    show(container: HTMLDivElement, theme: EditorTheme): editor.IStandaloneCodeEditor;
    getContent(): string;
    setContent(content: string): void;
    forceRedraw(): void;
    doResize(): void;
    private getMonacoThemeByEditorTheme;
    dispose(): void;
}
//# sourceMappingURL=FormEditorController.d.ts.map