export const sourceHandler = (source) => {
    var _a, _b, _c, _d;
    const importsReg = /\{([^)]+)\}/;
    const reactImportsRegExp = /import React, {[^}]*}.*(?=["']react['"]).*/gim;
    const reactImports = new RegExp(reactImportsRegExp).exec(source);
    if (!reactImports) {
        return;
    }
    const reactElements = (_a = importsReg.exec(reactImports[0])) === null || _a === void 0 ? void 0 : _a[1];
    const patternflyImportsRegExp = /import {[^}]*}.*(?=['"]@patternfly\/react-core['"]).*/gim;
    const patternflyImports = new RegExp(patternflyImportsRegExp).exec(source);
    if (!patternflyImports) {
        return;
    }
    const patternflyElements = (_b = importsReg.exec(patternflyImports[0])) === null || _b === void 0 ? void 0 : _b[1];
    const patternflyIconImportsRegExp = /import {[^}]*}.*(?=['"]@patternfly\/react-icons['"]).*/gim;
    const patternflyIconImports = new RegExp(patternflyIconImportsRegExp).exec(source);
    const patternflyIconElements = (_d = importsReg.exec((_c = patternflyIconImports === null || patternflyIconImports === void 0 ? void 0 : patternflyIconImports[0]) !== null && _c !== void 0 ? _c : "")) === null || _d === void 0 ? void 0 : _d[1];
    const trimmedSource = source
        .split(reactImportsRegExp)
        .join("")
        .trim()
        .split(patternflyImportsRegExp)
        .join("")
        .trim()
        .split(patternflyIconImportsRegExp)
        .join("")
        .trim();
    const formName = trimmedSource.split(": React.FC")[0].split("const ")[1];
    return {
        reactElements: reactElements,
        patternflyElements: patternflyElements,
        patternflyIconElements: patternflyIconElements,
        formName,
        trimmedSource,
    };
};
//# sourceMappingURL=utils.js.map