import { jsx as _jsx } from "react/jsx-runtime";
import React, { useImperativeHandle, useState } from "react";
import ProcessDefinitionList from "./components/ProcessDefinitionList/ProcessDefinitionList";
import ProcessDefinitionListEnvelopeViewDriver from "./ProcessDefinitionListEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
export const ProcessDefinitionListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [singularProcessLabel, setSingularProcessLabel] = useState("");
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setSingularProcessLabel(initArgs.singularProcessLabel);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(ProcessDefinitionList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new ProcessDefinitionListEnvelopeViewDriver(props.channelApi), singularProcessLabel: singularProcessLabel }) }));
});
export default ProcessDefinitionListEnvelopeView;
//# sourceMappingURL=ProcessDefinitionListEnvelopeView.js.map