import { jsx as _jsx } from "react/jsx-runtime";
import * as React from "react";
import { useImperativeHandle, useState } from "react";
import ProcessList from "./components/ProcessList/ProcessList";
import ProcessListEnvelopeViewDriver from "./ProcessListEnvelopeViewDriver";
import "@patternfly/patternfly/patternfly.css";
import { ProcessInstanceState } from "@kie-tools/runtime-tools-process-gateway-api/dist/types";
import { OrderBy } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const defaultFilters = {
    status: [ProcessInstanceState.Active],
    businessKey: [],
};
const defaultSortBy = {
    lastUpdate: OrderBy.DESC,
};
export const ProcessListEnvelopeView = React.forwardRef((props, forwardedRef) => {
    const [isEnvelopeConnectedToChannel, setEnvelopeConnectedToChannel] = useState(false);
    const [processInitialArgs, setProcessInitialArgs] = useState({
        initialState: {
            filters: defaultFilters,
            sortBy: defaultSortBy,
        },
        singularProcessLabel: "Process",
        pluralProcessLabel: "Processes",
    });
    useImperativeHandle(forwardedRef, () => ({
        initialize: (initArgs) => {
            setEnvelopeConnectedToChannel(false);
            setProcessInitialArgs(initArgs);
            setEnvelopeConnectedToChannel(true);
        },
    }), []);
    return (_jsx(React.Fragment, { children: _jsx(ProcessList, { isEnvelopeConnectedToChannel: isEnvelopeConnectedToChannel, driver: new ProcessListEnvelopeViewDriver(props.channelApi), initialState: processInitialArgs.initialState, singularProcessLabel: processInitialArgs === null || processInitialArgs === void 0 ? void 0 : processInitialArgs.singularProcessLabel, pluralProcessLabel: processInitialArgs === null || processInitialArgs === void 0 ? void 0 : processInitialArgs.pluralProcessLabel }) }));
});
export default ProcessListEnvelopeView;
//# sourceMappingURL=ProcessListEnvelopeView.js.map