import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useCallback, useEffect, useState, useMemo } from "react";
import ProcessListTable from "../ProcessListTable/ProcessListTable";
import ProcessListToolbar from "../ProcessListToolbar/ProcessListToolbar";
import _ from "lodash";
import { alterOrderByObj, processListDefaultStatusFilter } from "../utils/ProcessListUtils";
import { useCancelableEffect } from "@kie-tools-core/react-hooks/dist/useCancelableEffect";
import "../styles.css";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { ServerErrors } from "@kie-tools/runtime-tools-components/dist/components/ServerErrors";
import { LoadMore } from "@kie-tools/runtime-tools-components/dist/components/LoadMore";
import { KogitoEmptyState, KogitoEmptyStateType, } from "@kie-tools/runtime-tools-components/dist/components/KogitoEmptyState";
import { OrderBy } from "@kie-tools/runtime-tools-shared-gateway-api/dist/types";
const ProcessList = ({ driver, isEnvelopeConnectedToChannel, initialState, singularProcessLabel, pluralProcessLabel, ouiaId, ouiaSafe, }) => {
    const defaultFilters = useMemo(() => initialState && initialState.filters
        ? { ...initialState.filters }
        : {
            status: processListDefaultStatusFilter,
            businessKey: [],
        }, [initialState]);
    const defaultOrderBy = useMemo(() => initialState && initialState.sortBy
        ? initialState.sortBy
        : {
            lastUpdate: OrderBy.DESC,
        }, [initialState]);
    const [defaultPageSize] = useState(10);
    const [isLoading, setIsLoading] = useState(false);
    const [isLoadingMore, setIsLoadingMore] = useState(false);
    const [offset, setOffset] = useState(0);
    const [limit, setLimit] = useState(defaultPageSize);
    const [pageSize, setPageSize] = useState(defaultPageSize);
    const [processInstances, setProcessInstances] = useState([]);
    const [error, setError] = useState();
    const [filters, setFilters] = useState(defaultFilters);
    const [processStates, setProcessStates] = useState(processListDefaultStatusFilter);
    const [expanded, setExpanded] = React.useState({});
    const [sortBy, setSortBy] = useState(defaultOrderBy);
    const [selectedInstances, setSelectedInstances] = useState([]);
    const [selectableInstances, setSelectableInstances] = useState(0);
    const [isAllChecked, setIsAllChecked] = useState(false);
    const [isInitialLoadDone, setIsInitialLoadDone] = useState(false);
    useEffect(() => {
        if (!isEnvelopeConnectedToChannel) {
            setIsInitialLoadDone(false);
        }
    }, [isEnvelopeConnectedToChannel]);
    const countExpandableRows = useCallback((instances) => {
        instances.forEach((processInstance, index) => {
            var _a;
            expanded[index] = false;
            processInstance.isSelected = false;
            processInstance.isOpen = false;
            processInstance.childProcessInstances = [];
            if (processInstance.serviceUrl && ((_a = processInstance.addons) === null || _a === void 0 ? void 0 : _a.includes("process-management"))) {
                setSelectableInstances((prev) => prev + 1);
            }
        });
    }, [expanded]);
    const doQuery = useCallback(async (_offset, _limit, _resetProcesses, _resetPagination = false, _loadMore = false) => {
        setIsLoading(true);
        setIsLoadingMore(_loadMore);
        setSelectableInstances(0);
        setSelectedInstances([]);
        setError(undefined);
        try {
            const response = await driver.query(_offset, _limit);
            setLimit(response.length);
            if (_resetProcesses) {
                countExpandableRows(response);
                setProcessInstances(response);
            }
            else {
                setProcessInstances((currentProcessInstances) => {
                    const newData = currentProcessInstances.concat(response);
                    countExpandableRows(newData);
                    return newData;
                });
            }
            if (_resetPagination) {
                setOffset(_offset);
            }
        }
        catch (err) {
            setError(JSON.parse(JSON.parse(err.message).errorMessage));
        }
        finally {
            setIsLoading(false);
            setIsLoadingMore(false);
        }
    }, [countExpandableRows, driver]);
    useCancelableEffect(useCallback(({ canceled }) => {
        if (isEnvelopeConnectedToChannel && !isInitialLoadDone) {
            setFilters(defaultFilters);
            driver
                .initialLoad(defaultFilters, defaultOrderBy)
                .then(() => {
                if (canceled.get()) {
                    return;
                }
                return doQuery(0, 10, true);
            })
                .then(() => {
                if (canceled.get()) {
                    return;
                }
                setIsInitialLoadDone(true);
            });
        }
    }, [defaultFilters, defaultOrderBy, doQuery, driver, isEnvelopeConnectedToChannel, isInitialLoadDone]));
    useEffect(() => {
        if (initialState && initialState.filters) {
            setFilters(initialState.filters);
            setProcessStates(initialState.filters.status);
            setSortBy(initialState.sortBy);
        }
    }, [initialState]);
    useEffect(() => {
        if (selectedInstances.length === selectableInstances && selectableInstances !== 0) {
            setIsAllChecked(true);
        }
        else {
            setIsAllChecked(false);
        }
    }, [processInstances, selectableInstances, selectedInstances.length]);
    const applyFilter = useCallback(async (filter) => {
        setProcessInstances([]);
        await driver.applyFilter(filter);
        await doQuery(0, defaultPageSize, true, true);
    }, [defaultPageSize, doQuery, driver]);
    const applySorting = useCallback(async (event, index, direction) => {
        setProcessInstances([]);
        setSortBy({ index, direction });
        let sortingColumn = event.target.innerText;
        sortingColumn = _.camelCase(sortingColumn);
        let sortByObj = _.set({}, sortingColumn, direction.toUpperCase());
        sortByObj = alterOrderByObj(sortByObj);
        await driver.applySorting(sortByObj);
        await doQuery(0, defaultPageSize, true, true);
    }, [defaultPageSize, doQuery, driver]);
    const doRefresh = useCallback(async () => {
        setProcessInstances([]);
        await doQuery(0, defaultPageSize, true, true);
    }, [defaultPageSize, doQuery]);
    const doResetFilters = useCallback(async () => {
        const resetFilter = {
            status: processListDefaultStatusFilter,
            businessKey: [],
        };
        setProcessStates(processListDefaultStatusFilter);
        setFilters(resetFilter);
        await applyFilter(resetFilter);
    }, [applyFilter]);
    const mustShowLoadMore = (!isLoading || isLoadingMore) && processInstances && limit === pageSize && filters.status.length > 0;
    if (error) {
        return _jsx(ServerErrors, { error: error, variant: "large" });
    }
    return (_jsxs("div", { ...componentOuiaProps(ouiaId, "process-list", ouiaSafe ? ouiaSafe : !isLoading), children: [_jsx(ProcessListToolbar, { applyFilter: applyFilter, refresh: doRefresh, filters: filters, setFilters: setFilters, processStates: processStates, setProcessStates: setProcessStates, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, processInstances: processInstances, setProcessInstances: setProcessInstances, isAllChecked: isAllChecked, setIsAllChecked: setIsAllChecked, driver: driver, defaultStatusFilter: processListDefaultStatusFilter, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel }), filters.status.length > 0 ? (_jsxs(_Fragment, { children: [_jsx(ProcessListTable, { processInstances: processInstances, isLoading: isLoading, expanded: expanded, setExpanded: setExpanded, driver: driver, onSort: applySorting, sortBy: sortBy, setProcessInstances: setProcessInstances, selectedInstances: selectedInstances, setSelectedInstances: setSelectedInstances, selectableInstances: selectableInstances, setSelectableInstances: setSelectableInstances, setIsAllChecked: setIsAllChecked, singularProcessLabel: singularProcessLabel, pluralProcessLabel: pluralProcessLabel }), mustShowLoadMore && (_jsx(LoadMore, { offset: offset, setOffset: setOffset, getMoreItems: (_offset, _limit) => {
                            setPageSize(_limit);
                            doQuery(_offset, _limit, false, true, true);
                        }, pageSize: pageSize, isLoadingMore: isLoadingMore }))] })) : (_jsx("div", { className: "kogito-process-list__emptyState-card", children: _jsx(KogitoEmptyState, { type: KogitoEmptyStateType.Reset, title: "No filters applied.", body: "Try applying at least one filter to see results", onClick: doResetFilters }) }))] }));
};
export default ProcessList;
//# sourceMappingURL=ProcessList.js.map