import Element from "./Element";
import ErrorProcessor from "../utils/tools/ErrorProcessor";
import LocatorWaitAction from "./LocatorWaitAction";
export default class Locator {
    constructor(driver, by) {
        this.driver = driver;
        this.by = by;
    }
    wait(timeout) {
        return new LocatorWaitAction(this.driver, this.by, timeout);
    }
    async getElements() {
        return await ErrorProcessor.run(async () => {
            const webElements = await this.driver.findElements(this.by);
            return webElements.map((webElement) => new Element(webElement));
        }, "Error while getting elements: " + this.by);
    }
    async getElement() {
        return await ErrorProcessor.run(async () => {
            const webElement = await this.driver.findElement(this.by);
            return new Element(webElement);
        }, "Error while getting element: " + this.by);
    }
}
//# sourceMappingURL=Locator.js.map