import { By } from "selenium-webdriver";
import EditorPage from "../editor/EditorPage";
import FullScreenPage from "../fullscreen-editor/FullScreenPage";
class GitHubEditorPage extends EditorPage {
    async waitUntilLoaded() {
        return await this.tools.by(GitHubEditorPage.KOGITO_TOOLBAR_LOCATOR).wait(2000).untilPresent();
    }
    async copyLinkToOnlineEditor() {
        const copyLinkButton = await this.tools.by(GitHubEditorPage.COPY_LINK_BUTTON_LOCATOR).getElement();
        await copyLinkButton.click();
        await this.tools.by(GitHubEditorPage.COPY_LINK_ALERT_LOCATOR).wait(1000).untilPresent();
        return await this.tools.by(GitHubEditorPage.COPY_LINK_ALERT_LOCATOR).wait(5000).untilAbsent();
    }
    async seeAsSource() {
        const seeAsSourceButton = await this.tools.by(GitHubEditorPage.SEE_AS_SOURCE_BUTTON_LOCATOR).getElement();
        return await seeAsSourceButton.click();
    }
    async seeAsDiagram() {
        const seeAsDiagramButton = await this.tools.by(GitHubEditorPage.SEE_AS_DIAGRAM_BUTTON_LOCATOR).getElement();
        return await seeAsDiagramButton.click();
    }
    async isSourceVisible() {
        return await this.tools.by(GitHubEditorPage.SOURCE_VIEW_LOCATOR).wait(1000).isVisible();
    }
    async isEditorVisible() {
        return await this.tools.by(GitHubEditorPage.KOGITO_CONTAINER_LOCATOR).wait(1000).isVisible();
    }
    async fullScreen() {
        const fullScreenButton = await this.tools.by(GitHubEditorPage.FULL_SCREEN_BUTTON_LOCATOR).getElement();
        await fullScreenButton.click();
        return await this.tools.createPage(FullScreenPage);
    }
}
GitHubEditorPage.SEE_AS_SOURCE_BUTTON_LOCATOR = By.xpath("//button[@data-testid='see-as-source-button']");
GitHubEditorPage.COPY_LINK_BUTTON_LOCATOR = By.xpath("//button[@data-testid='copy-link-button']");
GitHubEditorPage.COPY_LINK_ALERT_LOCATOR = By.xpath("//div[@data-testid='link-copied-alert']");
GitHubEditorPage.SEE_AS_DIAGRAM_BUTTON_LOCATOR = By.xpath("//button[@data-testid='see-as-diagram-button']");
GitHubEditorPage.FULL_SCREEN_BUTTON_LOCATOR = By.xpath("//button[@data-testid='go-fullscreen-button']");
GitHubEditorPage.SOURCE_VIEW_LOCATOR = By.xpath("//textarea[@id='read-only-cursor-text-area']");
GitHubEditorPage.KOGITO_CONTAINER_LOCATOR = By.className("kogito-iframe-container");
GitHubEditorPage.KOGITO_TOOLBAR_LOCATOR = By.className("kogito-toolbar-container");
export default GitHubEditorPage;
//# sourceMappingURL=GitHubEditorPage.js.map