import { By } from "selenium-webdriver";
import GitHubListItem from "./GitHubListItem";
import Page from "../Page";
class GitHubListPage extends Page {
    async waitUntilLoaded() {
        return await this.tools.by(GitHubListPage.DOUBLE_DOT_LOCATOR).wait(1000).untilPresent();
    }
    async getFile(name) {
        const file = By.xpath(`//td[@class='react-directory-row-name-cell-large-screen'][.//a[@title='${name}']]`);
        await this.tools.by(file).wait(5000).untilPresent();
        return await this.tools.createPageFragment(GitHubListItem, await this.tools.by(file).getElement());
    }
}
GitHubListPage.DOUBLE_DOT_LOCATOR = By.xpath("//h3[@data-testid='screen-reader-heading']");
export default GitHubListPage;
//# sourceMappingURL=GitHubListPage.js.map