import ErrorProcessor from "./ErrorProcessor";
export default class Window {
    constructor(driver) {
        this.driver = driver;
    }
    async leaveFrame() {
        return await ErrorProcessor.run(async () => await this.driver.switchTo().defaultContent(), "Error when switching to default content.");
    }
    async scrollToTop() {
        return await ErrorProcessor.run(async () => await this.driver.executeScript("window.scrollTo(0, 0);"), "Error when scrolling to top of page.");
    }
    async switchToSecondWindow() {
        await this.waitForAnotherWindow();
        const windowHandles = await this.getWindowHandles();
        if (windowHandles.length > 1) {
            return await this.switchToWindow(windowHandles[1]);
        }
        else {
            throw new Error("Second window was not found.");
        }
    }
    async switchToWindow(windowHandle) {
        return await ErrorProcessor.run(async () => await this.driver.switchTo().window(windowHandle), "Error while switching to window.");
    }
    async getWindowHandles() {
        return await ErrorProcessor.run(async () => await this.driver.getAllWindowHandles(), "Error while getting window handles.");
    }
    async waitForAnotherWindow() {
        return await ErrorProcessor.run(async () => {
            await this.driver.wait(async () => {
                const windowHandles = await this.driver.getAllWindowHandles();
                return windowHandles.length > 1;
            }, 5000);
        }, "Error when waiting for second window.");
    }
}
//# sourceMappingURL=Window.js.map