import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import { PlayIcon } from "@patternfly/react-icons/dist/js/icons/play-icon";
import { SitemapIcon } from "@patternfly/react-icons/dist/js/icons/sitemap-icon";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
export const getColumn = (columnPath, columnLabel) => {
    return {
        label: columnLabel,
        path: columnPath,
        bodyCellTransformer: (value) => _jsx("span", { children: value }),
    };
};
export const getActionColumn = (startWorkflow, triggerCloudEvent) => {
    return {
        label: "Actions",
        path: "actions",
        bodyCellTransformer: (value, rowData) => (_jsxs(_Fragment, { children: [_jsx(Tooltip, { content: `Start new workflow`, children: _jsx(Button, { onClick: () => startWorkflow(rowData), variant: "link", children: _jsx(PlayIcon, {}) }) }), _jsx(Tooltip, { content: `Trigger cloud event`, children: _jsx(Button, { onClick: () => triggerCloudEvent(rowData), variant: "link", children: _jsx(SitemapIcon, {}) }) })] })),
    };
};
//# sourceMappingURL=WorkflowDefinitionListUtils.js.map