import { jsx as _jsx, Fragment as _Fragment, jsxs as _jsxs } from "react/jsx-runtime";
import React, { useState, useEffect } from "react";
import { Card, CardHeader, CardBody } from "@patternfly/react-core/dist/js/components/Card";
import { Tooltip } from "@patternfly/react-core/dist/js/components/Tooltip";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Table, TableVariant, TableHeader, TableBody, } from "@patternfly/react-table/dist/js/components/Table";
import Moment from "react-moment";
import JobActionsKebab from "../JobActionsKebab/JobActionsKebab";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { JobsIconCreator } from "../../../utils/Utils";
const JobsPanel = ({ jobs, driver, ouiaId, ouiaSafe }) => {
    const [rows, setRows] = useState([]);
    const columns = [
        {
            title: "Job id",
        },
        {
            title: "Status",
        },
        {
            title: "Expiration time",
        },
        {
            title: "Actions",
        },
    ];
    const createRows = (jobsArray) => {
        const jobRows = [];
        jobsArray.forEach((job) => {
            jobRows.push({
                cells: [
                    {
                        title: (_jsx(Tooltip, { content: job.id, children: _jsx("span", { children: job.id.substring(0, 7) }) })),
                    },
                    {
                        title: JobsIconCreator(job.status),
                    },
                    {
                        title: (_jsx(React.Fragment, { children: job.expirationTime ? (_jsxs(_Fragment, { children: [" ", "expires in", " ", _jsx(Moment, { fromNow: true, ago: true, children: job.expirationTime })] })) : ("N/A") })),
                    },
                    {
                        title: _jsx(JobActionsKebab, { job: job, driver: driver }),
                    },
                ],
            });
        });
        return jobRows;
    };
    useEffect(() => {
        if (jobs.length > 0) {
            setRows(createRows(jobs));
        }
    }, [jobs]);
    if (jobs.length > 0) {
        return (_jsxs(Card, { ...componentOuiaProps(ouiaId, "workflow-details-jobs-panel"), children: [_jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Jobs" }) }), _jsx(CardBody, { children: _jsxs(Table, { "aria-label": "Workflow details jobs panel", "aria-labelledby": "Workflow details jobs panel", variant: TableVariant.compact, rows: rows, cells: columns, children: [_jsx(TableHeader, {}), _jsx(TableBody, {})] }) })] }));
    }
    else {
        return null;
    }
};
export default JobsPanel;
//# sourceMappingURL=JobsPanel.js.map