import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import Moment from "react-moment";
import { Card, CardBody, CardHeader } from "@patternfly/react-core/dist/js/components/Card";
import { Button } from "@patternfly/react-core/dist/js/components/Button";
import { Title } from "@patternfly/react-core/dist/js/components/Title";
import { Form, FormGroup } from "@patternfly/react-core/dist/js/components/Form";
import { Text, TextVariants } from "@patternfly/react-core/dist/js/components/Text";
import { LevelDownAltIcon } from "@patternfly/react-icons/dist/js/icons/level-down-alt-icon";
import { LevelUpAltIcon } from "@patternfly/react-icons/dist/js/icons/level-up-alt-icon";
import { ItemDescriptor } from "@kie-tools/runtime-tools-components/dist/components/ItemDescriptor";
import { EndpointLink } from "@kie-tools/runtime-tools-components/dist/components/EndpointLink";
import { componentOuiaProps } from "@kie-tools/runtime-tools-components/dist/ouiaTools";
import { WorkflowInstanceIconCreator, getWorkflowInstanceDescription } from "../../../utils/Utils";
const WorkflowDetailsPanel = ({ workflowInstance, driver, ouiaId, ouiaSafe }) => {
    return (_jsxs(Card, { ...componentOuiaProps(ouiaId ? ouiaId : workflowInstance.id, "workflow-details", ouiaSafe), children: [_jsx(CardHeader, { children: _jsx(Title, { headingLevel: "h3", size: "xl", children: "Details" }) }), _jsx(CardBody, { children: _jsxs(Form, { children: [_jsx(FormGroup, { label: "Name", fieldId: "name", children: _jsx(Text, { component: TextVariants.p, children: workflowInstance.processName }) }), workflowInstance.businessKey && (_jsx(FormGroup, { label: "Business key", fieldId: "businessKey", children: _jsx(Text, { component: TextVariants.p, children: workflowInstance.businessKey }) })), _jsx(FormGroup, { label: "State", fieldId: "state", children: _jsx(Text, { component: TextVariants.p, children: WorkflowInstanceIconCreator(workflowInstance.state) }) }), _jsx(FormGroup, { label: "Id", fieldId: "id", children: _jsx(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak", children: workflowInstance.id }) }), workflowInstance.serviceUrl ? (_jsx(FormGroup, { label: "Endpoint", fieldId: "endpoint", children: _jsx(Text, { component: TextVariants.p, className: "kogito-management-console--u-WordBreak", children: _jsx(EndpointLink, { serviceUrl: workflowInstance.serviceUrl, isLinkShown: true }) }) })) : (""), _jsx(FormGroup, { label: "Start", fieldId: "start", children: workflowInstance.start ? (_jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${workflowInstance.start}`) }) })) : ("") }), workflowInstance.lastUpdate && (_jsx(FormGroup, { label: "Last Updated", fieldId: "lastUpdate", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${workflowInstance.lastUpdate}`) }) }) })), workflowInstance.end && (_jsx(FormGroup, { label: "End", fieldId: "end", children: _jsx(Text, { component: TextVariants.p, children: _jsx(Moment, { fromNow: true, children: new Date(`${workflowInstance.end}`) }) }) })), workflowInstance.parentWorkflowInstance && (_jsx(FormGroup, { label: "Parent Workflow", fieldId: "parent", children: _jsx("div", { children: _jsx(Button, { "data-testid": "open-parent-workflow", variant: "link", icon: _jsx(LevelUpAltIcon, {}), onClick: () => {
                                        driver.openWorkflowInstanceDetails(workflowInstance.parentWorkflowInstance.id);
                                    }, ...componentOuiaProps(ouiaId ? ouiaId : workflowInstance.parentWorkflowInstance.id, "workflow-details", ouiaSafe), children: _jsx(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(workflowInstance.parentWorkflowInstance) }) }) }) })), workflowInstance.childWorkflowInstances && workflowInstance.childWorkflowInstances.length !== 0 && (_jsx(FormGroup, { label: "Sub Workflows", fieldId: "child", children: workflowInstance.childWorkflowInstances.map((child) => (_jsx("div", { children: _jsx(Button, { variant: "link", icon: _jsx(LevelDownAltIcon, {}), onClick: () => {
                                        driver.openWorkflowInstanceDetails(child.id);
                                    }, ...componentOuiaProps(ouiaId ? ouiaId : child.id, "workflow-details", ouiaSafe), children: _jsx(ItemDescriptor, { itemDescription: getWorkflowInstanceDescription(child) }) }) }, child.id))) }))] }) })] }));
};
export default WorkflowDetailsPanel;
//# sourceMappingURL=WorkflowDetailsPanel.js.map