export class JobsManagementGatewayApiImpl {
    constructor(queries) {
        this.onUpdateJobsManagementStateListeners = [];
        this.initialLoad = (filter, orderBy) => {
            this._JobsManagementState.filters = filter;
            this._JobsManagementState.orderBy = orderBy;
            return Promise.resolve();
        };
        this.applyFilter = (filter) => {
            this._JobsManagementState.filters = filter;
            this.onUpdateJobsManagementStateListeners.forEach((listener) => listener.onUpdate(this._JobsManagementState));
            return Promise.resolve();
        };
        this.cancelJob = async (job) => {
            const cancelResult = await this.queries.cancelJob(job);
            return cancelResult;
        };
        this.rescheduleJob = async (job, repeatInterval, repeatLimit, scheduleDate) => {
            const rescheduleResult = await this.queries.rescheduleJob(job, repeatInterval, repeatLimit, scheduleDate);
            return rescheduleResult;
        };
        this.bulkCancel = (jobsToBeActioned) => {
            return this.queries.bulkCancel(jobsToBeActioned);
        };
        this.sortBy = (orderBy) => {
            this._JobsManagementState.orderBy = orderBy;
            this.onUpdateJobsManagementStateListeners.forEach((listener) => listener.onUpdate(this._JobsManagementState));
            return Promise.resolve();
        };
        this.queries = queries;
        this._JobsManagementState = { filters: [], orderBy: {} };
    }
    get jobsManagementState() {
        return this._JobsManagementState;
    }
    onUpdateJobsManagementState(listener) {
        this.onUpdateJobsManagementStateListeners.push(listener);
        const unSubscribe = () => {
            const index = this.onUpdateJobsManagementStateListeners.indexOf(listener);
            if (index > -1) {
                this.onUpdateJobsManagementStateListeners.splice(index, 1);
            }
        };
        return {
            unSubscribe,
        };
    }
    query(offset, limit) {
        return new Promise((resolve, reject) => {
            this.queries
                .getJobs(offset, limit, this._JobsManagementState.filters, this._JobsManagementState.orderBy)
                .then((value) => {
                resolve(value);
            })
                .catch((reason) => {
                reject(reason);
            });
        });
    }
}
//# sourceMappingURL=JobsManagementGatewayApi.js.map