import axios from "axios";
import { ANONYMOUS_USER } from "@kie-tools/runtime-tools-components/dist/contexts/KogitoAppContext";
export class TaskFormGatewayApiImpl {
    constructor(getCurrentUser, transformEndpointBaseUrl) {
        this.getCurrentUser = getCurrentUser;
        this.transformEndpointBaseUrl = transformEndpointBaseUrl;
    }
    submitTaskForm(endpoint, transition, headers) {
        return new Promise((resolve, reject) => {
            axios
                .post(this.transformEndpointBaseUrl(endpoint), transition, {
                headers: {
                    "Content-Type": "application/json",
                    Accept: "application/json",
                    ...headers,
                },
            })
                .then((response) => {
                if (response.status == 200) {
                    resolve(response.data);
                }
                else {
                    reject(response);
                }
            })
                .catch((error) => reject(error));
        });
    }
    fetchTaskFormSchema(endpoint, headers) {
        return new Promise((resolve, reject) => {
            axios
                .get(this.transformEndpointBaseUrl(endpoint), {
                headers: {
                    "Content-Type": "application/json",
                    Accept: "application/json",
                    ...headers,
                },
            })
                .then((response) => {
                if (response.status == 200) {
                    resolve(response.data);
                }
                else {
                    reject(response);
                }
            })
                .catch((error) => reject(error));
        });
    }
    fetchCustomForm(endpoint, headers) {
        return new Promise((resolve, reject) => {
            axios
                .get(this.transformEndpointBaseUrl(endpoint), {
                headers: {
                    "Content-Type": "application/json",
                    Accept: "application/json",
                    ...headers,
                },
            })
                .then((response) => {
                if (response.status == 200) {
                    resolve(response.data);
                }
                else {
                    reject(response);
                }
            })
                .catch((error) => reject(error));
        });
    }
    fetchTaskTransitionPhases(endpoint, headers) {
        return new Promise((resolve, reject) => {
            axios
                .get(this.transformEndpointBaseUrl(endpoint), {
                headers: {
                    "Content-Type": "application/json",
                    Accept: "application/json",
                    ...headers,
                },
            })
                .then((response) => {
                if (response.status == 200) {
                    const transitions = response.data;
                    resolve(transitions.map((transition) => transition.transitionId));
                }
                else {
                    reject(response);
                }
            })
                .catch((error) => reject(error));
        });
    }
    doSubmit(userTask, phase, payload, headers) {
        const endpoint = getTaskTransitionsEndpoint(userTask, this.getCurrentUser());
        const transition = {
            transitionId: phase,
            data: payload,
        };
        return this.submitTaskForm(endpoint, transition, headers);
    }
    getTaskFormSchema(userTask, headers) {
        const endpoint = getTaskSchemaEndPoint(userTask, this.getCurrentUser());
        return this.fetchTaskFormSchema(endpoint, headers);
    }
    getCustomForm(userTask, headers) {
        const baseUrl = cleanUserTaskEndpoint(userTask);
        const endpoint = `${baseUrl}/forms/${userTask.processId}_${userTask.name}`;
        return this.fetchCustomForm(endpoint, headers);
    }
    getTaskPhases(userTask, headers) {
        const endpoint = getTaskTransitionsEndpoint(userTask, this.getCurrentUser());
        return this.fetchTaskTransitionPhases(endpoint, headers);
    }
}
function getTaskTransitionsEndpoint(task, user) {
    const baseUrl = cleanUserTaskEndpoint(task);
    const params = getTaskEndpointSecurityParams(task, user);
    return `${baseUrl}/usertasks/instance/${task.id}/transition?${params}`;
}
function getTaskSchemaEndPoint(task, user) {
    let endpoint = task.endpoint;
    endpoint = endpoint.slice(0, -(task.id.length + 1));
    endpoint = endpoint.replace(task.processInstanceId + "/", "");
    return `${endpoint}/schema`;
}
function getTaskEndpointSecurityParams(task, user) {
    var _a, _b;
    if (!user || user.id === ANONYMOUS_USER.id) {
        return `user=${(_b = (_a = task.potentialUsers) === null || _a === void 0 ? void 0 : _a[0]) !== null && _b !== void 0 ? _b : "Dev User"}`;
    }
    let groups = "";
    if (user.groups && user.groups.length > 0) {
        groups = `&group=${user.groups.join("&group=")}`;
    }
    return `${user.id ? `user=${user.id}` : ""}${groups}`;
}
function cleanUserTaskEndpoint(task) {
    const suffix = calculateUserTaskEndpointSuffix(task);
    return task.endpoint.slice(0, -suffix.length);
}
function calculateUserTaskEndpointSuffix(task) {
    return `/${task.processId}/${task.processInstanceId}/${task.name}/${task.externalReferenceId}`;
}
//# sourceMappingURL=TaskFormGatewayApi.js.map