"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.createNewFileCodeLens = exports.createOpenCompletionItemsCodeLenses = exports.createCodeLenses = void 0;
var vscode_languageserver_types_1 = require("vscode-languageserver-types");
var findNodesAtLocation_1 = require("./findNodesAtLocation");
var createCodeLenses = function (args) {
    var nodes = (0, findNodesAtLocation_1.findNodesAtLocation)({ root: args.rootNode, path: args.jsonPath });
    var codeLenses = nodes.flatMap(function (node) {
        var _a, _b;
        var position = args.positionLensAt === "end" &&
            (node.type === "object" || node.type === "array") &&
            ((_b = (_a = node.children) === null || _a === void 0 ? void 0 : _a.length) !== null && _b !== void 0 ? _b : 0) > 0
            ? args.document.positionAt(node.offset + node.length)
            : args.document.positionAt(node.offset);
        return args.commandDelegates({ position: position, node: node }).map(function (command) { return ({
            command: {
                command: command.name,
                title: command.title,
                arguments: command.args,
            },
            range: {
                start: position,
                end: position,
            },
        }); });
    });
    return codeLenses;
};
exports.createCodeLenses = createCodeLenses;
var createOpenCompletionItemsCodeLenses = function (args) {
    return (0, exports.createCodeLenses)(__assign(__assign({}, args), { positionLensAt: "begin", commandDelegates: function (_a) {
            var node = _a.node;
            var commandName = args.commandName || "editor.ls.commands.OpenCompletionItems";
            if (node.type !== args.nodeType ||
                !args.codeCompletionStrategy.shouldCreateCodelens({ node: node, commandName: commandName, content: args.content })) {
                return [];
            }
            var newCursorPosition = args.codeCompletionStrategy.getStartNodeValuePosition(args.document, node);
            return [
                {
                    name: commandName,
                    title: args.title,
                    args: [{ newCursorPosition: newCursorPosition }],
                },
            ];
        } }));
};
exports.createOpenCompletionItemsCodeLenses = createOpenCompletionItemsCodeLenses;
var createNewFileCodeLens = function (title) {
    var position = vscode_languageserver_types_1.Position.create(0, 0);
    var command = "editor.ls.commands.OpenCompletionItems";
    return [
        {
            command: {
                command: command,
                title: title,
                arguments: [{ newCursorPosition: position }],
            },
            range: {
                start: position,
                end: position,
            },
        },
    ];
};
exports.createNewFileCodeLens = createNewFileCodeLens;
//# sourceMappingURL=EditorLanguageServiceCodeLenses.js.map