"use strict";
var __assign = (this && this.__assign) || function () {
    __assign = Object.assign || function(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p))
                t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
var jsx_runtime_1 = require("react/jsx-runtime");
var Checkbox_1 = require("@patternfly/react-core/dist/js/components/Checkbox");
var Switch_1 = require("@patternfly/react-core/dist/js/components/Switch");
var uniforms_1 = require("uniforms");
var wrapField_1 = __importDefault(require("./wrapField"));
var ComponentType;
(function (ComponentType) {
    ComponentType["checkbox"] = "checkbox";
    ComponentType["switch"] = "switch";
})(ComponentType || (ComponentType = {}));
function BoolField(_a) {
    var appearance = _a.appearance, disabled = _a.disabled, id = _a.id, inputRef = _a.inputRef, label = _a.label, name = _a.name, onChange = _a.onChange, value = _a.value, props = __rest(_a, ["appearance", "disabled", "id", "inputRef", "label", "name", "onChange", "value"]);
    var Component = appearance === ComponentType.switch ? Switch_1.Switch : Checkbox_1.Checkbox;
    return (0, wrapField_1.default)(__assign({ id: id }, props), (0, jsx_runtime_1.jsx)(Component, { "data-testid": "bool-field", isChecked: value !== null && value !== void 0 ? value : false, isDisabled: disabled, id: id, name: name, onChange: function () { return disabled || onChange(!value); }, ref: inputRef, label: label }));
}
BoolField.defaultProps = { appearance: ComponentType.checkbox };
exports.default = (0, uniforms_1.connectField)(BoolField);
//# sourceMappingURL=BoolField.js.map