import { jsx as _jsx } from "react/jsx-runtime";
import { connectField, filterDOMProps } from "uniforms";
function ErrorField({ children, error, errorMessage, ...props }) {
    return !error ? null : (_jsx("div", { "data-testid": "error-field", ...filterDOMProps(props), children: children ? children : _jsx("div", { style: { margin: "3px" }, children: errorMessage }) }));
}
ErrorField.defaultProps = {
    style: {
        backgroundColor: "rgba(255, 85, 0, 0.2)",
        border: "1px solid rgb(255, 85, 0)",
        borderRadius: "7px",
        margin: "20px 0px",
        padding: "10px",
    },
};
export default connectField(ErrorField, { initialValue: false });
//# sourceMappingURL=ErrorField.js.map