import { MiningSchema, RuleSetModel } from "../../model/pmml4_4";
import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
export const RULE_SET_MODEL = `
elements.elements[(name = "RuleSetModel")] ~> $map(function($v, $i) {
  $merge([
    $ruleSetModelFactory(),
    $v.attributes,
    {
      "_type": $v.name
    },
    {
      ${MINING_SCHEMA}, 
      ${OUTPUT},
      ${MODEL_STATS},
      ${MODEL_EXPLANATION},
      ${MODEL_VERIFICATION},
      ${TARGETS},
      ${LOCAL_TRANSFORMATIONS}
    }
  ])
})`;
export function ruleSetModelFactory() {
    return new RuleSetModel({
        MiningSchema: new MiningSchema({ MiningField: [] }),
        RuleSet: { RuleSelectionMethod: [] },
        functionName: "regression",
    });
}
//# sourceMappingURL=RuleSetModel.js.map