import { LOCAL_TRANSFORMATIONS } from "./LocalTransformations";
import { MINING_SCHEMA } from "./MiningSchema";
import { MODEL_EXPLANATION } from "./ModelExplanation";
import { MODEL_STATS } from "./ModelStats";
import { MODEL_VERIFICATION } from "./ModelVerification";
import { OUTPUT } from "./Output";
import { TARGETS } from "./Targets";
const PREDICATE = `[
  $v.predicate[] ~> $map(function($v, $i) {
    $ui2jsonPredicateFactory($v)
  })
]`;
const COMPLEX_PARTIAL_SCORE = `[
  $v.ComplexPartialScore ~> $map(function($v, $i) {
    $v
  })
]`;
const ATTRIBUTE = `
$v.Attribute ~> $map(function($v, $i) {
  {
    "type": "element",
    "name": "Attribute",
    "attributes": {
      "reasonCode": $v.reasonCode,
      "partialScore": $v.partialScore
    },
    "elements": $append(${PREDICATE}, ${COMPLEX_PARTIAL_SCORE})
  }
})`;
const CHARACTERISTIC = `[
  $v.Characteristic ~> $map(function($v, $i) {
    {
      "type": "element", 
      "name": "Characteristic", 
      "attributes": {
        "name": $v.name,
        "reasonCode": $v.reasonCode,
        "baselineScore": $v.baselineScore
      },
      "elements": $singletonArray(${ATTRIBUTE})
    }
  })
]`;
const CHARACTERISTICS = `
$v.Characteristics ~> $map(function($v, $i) {
  {
    "type": "element",
    "name": "Characteristics",
    "elements": $singletonArray(${CHARACTERISTIC})
  }
})`;
export const SCORE_CARD = `[
  models[(_type = "Scorecard")] ~> $map(function($v, $i) {
    {
      "type": "element",
      "name": "Scorecard",
      "attributes": {
        "modelName": $v.modelName,
        "functionName": $v.functionName,
        "algorithmName": $v.algorithmName,
        "initialScore": $v.initialScore,
        "useReasonCodes": $v.useReasonCodes,
        "reasonCodeAlgorithm": $v.reasonCodeAlgorithm,
        "baselineScore": $v.baselineScore,
        "baselineMethod": $v.baselineMethod,
        "isScorable": $v.isScorable
      },
      "elements": $append(${MINING_SCHEMA}, 
                    $append(${OUTPUT}, 
                      $append(${CHARACTERISTICS},
                        $append(${MODEL_STATS},
                          $append(${MODEL_EXPLANATION},
                            $append(${MODEL_VERIFICATION},
                              $append(${TARGETS},
                                $append([], ${LOCAL_TRANSFORMATIONS})
                              )
                            )
                          )
                        )
                      )
                    )
                  )
    }
  })
]`;
//# sourceMappingURL=Scorecard.js.map