/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.cql;

import com.datastax.oss.driver.api.core.PagingIterable;
import com.datastax.oss.driver.api.core.cql.AsyncResultSet;
import com.datastax.oss.driver.api.core.cql.ColumnDefinitions;
import com.datastax.oss.driver.api.core.cql.ExecutionInfo;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.internal.core.PagingIterableWrapper;
import com.datastax.oss.driver.internal.core.cql.PagingIterableSpliterator;
import com.datastax.oss.driver.shaded.guava.common.collect.ImmutableList;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Function;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class SinglePageResultSet
implements ResultSet {
    private final AsyncResultSet onlyPage;

    public SinglePageResultSet(AsyncResultSet onlyPage) {
        this.onlyPage = onlyPage;
        assert (!onlyPage.hasMorePages());
    }

    @Override
    @NonNull
    public ColumnDefinitions getColumnDefinitions() {
        return this.onlyPage.getColumnDefinitions();
    }

    @Override
    @NonNull
    public ExecutionInfo getExecutionInfo() {
        return this.onlyPage.getExecutionInfo();
    }

    @Override
    @NonNull
    public List<ExecutionInfo> getExecutionInfos() {
        return ImmutableList.of((Object)this.onlyPage.getExecutionInfo());
    }

    @Override
    public boolean isFullyFetched() {
        return true;
    }

    @Override
    public int getAvailableWithoutFetching() {
        return this.onlyPage.remaining();
    }

    @Override
    @NonNull
    public Iterator<Row> iterator() {
        return this.onlyPage.currentPage().iterator();
    }

    @Override
    @NonNull
    public Spliterator<Row> spliterator() {
        return PagingIterableSpliterator.builder(this).withEstimatedSize(this.getAvailableWithoutFetching()).build();
    }

    @Override
    @NonNull
    public <TargetElementT> PagingIterable<TargetElementT> map(Function<? super Row, ? extends TargetElementT> elementMapper) {
        return new PagingIterableWrapper<Row, TargetElementT>(this, elementMapper, true);
    }

    @Override
    public boolean wasApplied() {
        return this.onlyPage.wasApplied();
    }
}

