/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transforms;

import java.lang.reflect.Method;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAccessor;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ExecutableException;
import org.apache.juneau.internal.DateUtils;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.transform.StringSwap;
import org.apache.juneau.transforms.DefaultingTemporalAccessor;

public class TemporalSwap
extends StringSwap<Temporal> {
    private static final ZoneId Z = ZoneId.of("Z");
    private static final Map<Class<? extends Temporal>, Method> FROM_METHODS = new ConcurrentHashMap<Class<? extends Temporal>, Method>();
    private final DateTimeFormatter formatter;
    private final boolean zoneOptional;

    private static Method findParseMethod(Class<? extends Temporal> c) throws ExecutableException {
        Method m = FROM_METHODS.get(c);
        if (m == null) {
            m = ClassInfo.of(c).getStaticPublicMethodInner("from", c, TemporalAccessor.class);
            if (m == null) {
                throw new ExecutableException("Parse method not found on temporal class ''{0}''", c.getSimpleName());
            }
            FROM_METHODS.put(c, m);
        }
        return m;
    }

    public TemporalSwap(String pattern, boolean zoneOptional) {
        super(Temporal.class);
        this.formatter = DateUtils.getFormatter(pattern);
        this.zoneOptional = zoneOptional;
    }

    protected boolean zoneOptional() {
        return this.zoneOptional;
    }

    @Override
    public String swap(BeanSession session, Temporal o) throws Exception {
        if (o == null) {
            return null;
        }
        o = this.convertToSerializable(session, o);
        return this.formatter.format(o);
    }

    protected Temporal convertToSerializable(BeanSession session, Temporal t) {
        ZoneId zoneId = session.getTimeZoneId();
        Class<?> tc = t.getClass();
        if (tc == Instant.class) {
            return ZonedDateTime.from(this.defaulting(t, Z));
        }
        if (tc == ZonedDateTime.class || tc == OffsetDateTime.class) {
            return t;
        }
        if (this.zoneOptional()) {
            if (tc == LocalDateTime.class) {
                return t;
            }
            if (tc == OffsetTime.class) {
                return ZonedDateTime.from(this.defaulting(t, zoneId));
            }
            return LocalDateTime.from(this.defaulting(t, zoneId));
        }
        return ZonedDateTime.from(this.defaulting(t, zoneId));
    }

    @Override
    public Temporal unswap(BeanSession session, String f, ClassMeta<?> hint) throws Exception {
        if (hint == null) {
            hint = session.getClassMeta(Instant.class);
        }
        Class<?> tc = hint.getInnerClass();
        ZoneId offset = session.getTimeZoneId();
        if (tc == Instant.class) {
            offset = Z;
        }
        Method parseMethod = TemporalSwap.findParseMethod(tc);
        TemporalAccessor ta = this.defaulting(this.formatter.parse(f), offset);
        return (Temporal)parseMethod.invoke(null, ta);
    }

    private final TemporalAccessor defaulting(TemporalAccessor t, ZoneId zoneId) {
        return new DefaultingTemporalAccessor(t, zoneId);
    }

    public static class Rfc1123DateTime
    extends TemporalSwap {
        public Rfc1123DateTime() {
            super("RFC_1123_DATE_TIME", false);
        }
    }

    public static class IsoZonedDateTime
    extends TemporalSwap {
        public IsoZonedDateTime() {
            super("ISO_ZONED_DATE_TIME", false);
        }
    }

    public static class IsoYearMonth
    extends TemporalSwap {
        public IsoYearMonth() {
            super("uuuu-MM", true);
        }
    }

    public static class IsoYear
    extends TemporalSwap {
        public IsoYear() {
            super("uuuu", true);
        }
    }

    public static class IsoWeekDate
    extends TemporalSwap {
        public IsoWeekDate() {
            super("ISO_WEEK_DATE", true);
        }
    }

    public static class IsoTime
    extends TemporalSwap {
        public IsoTime() {
            super("ISO_TIME", true);
        }
    }

    public static class IsoOrdinalDate
    extends TemporalSwap {
        public IsoOrdinalDate() {
            super("ISO_ORDINAL_DATE", true);
        }
    }

    public static class IsoOffsetTime
    extends TemporalSwap {
        public IsoOffsetTime() {
            super("ISO_OFFSET_TIME", false);
        }
    }

    public static class IsoOffsetDateTime
    extends TemporalSwap {
        public IsoOffsetDateTime() {
            super("ISO_OFFSET_DATE_TIME", false);
        }
    }

    public static class IsoOffsetDate
    extends TemporalSwap {
        public IsoOffsetDate() {
            super("ISO_OFFSET_DATE", false);
        }
    }

    public static class IsoLocalTime
    extends TemporalSwap {
        public IsoLocalTime() {
            super("ISO_LOCAL_TIME", true);
        }
    }

    public static class IsoLocalDateTime
    extends TemporalSwap {
        public IsoLocalDateTime() {
            super("ISO_LOCAL_DATE_TIME", true);
        }
    }

    public static class IsoLocalDate
    extends TemporalSwap {
        public IsoLocalDate() {
            super("ISO_LOCAL_DATE", false);
        }
    }

    public static class IsoInstant
    extends TemporalSwap {
        public IsoInstant() {
            super("ISO_INSTANT", false);
        }
    }

    public static class IsoDateTime
    extends TemporalSwap {
        public IsoDateTime() {
            super("ISO_DATE_TIME", true);
        }
    }

    public static class IsoDate
    extends TemporalSwap {
        public IsoDate() {
            super("ISO_DATE", true);
        }
    }

    public static class BasicIsoDate
    extends TemporalSwap {
        public BasicIsoDate() {
            super("BASIC_ISO_DATE", true);
        }
    }
}

