/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Set;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.ASet;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.reflect.ClassInfo;
import org.apache.juneau.reflect.ConstructorInfo;
import org.apache.juneau.reflect.MethodInfo;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class AutoListSwap<T>
extends PojoSwap<T, List<?>> {
    private static final Set<String> SWAP_METHOD_NAMES = ASet.unmodifiable("toList", "toObjectList", "toOList");
    private static final Set<String> UNSWAP_METHOD_NAMES = ASet.unmodifiable("fromList", "fromObjectList", "fromOList", "create", "valueOf");
    private final Method swapMethod;
    private final Method unswapMethod;
    private final Constructor<?> unswapConstructor;

    public static PojoSwap<?, ?> find(BeanContext bc, ClassInfo ci) {
        if (AutoListSwap.shouldIgnore(bc, ci)) {
            return null;
        }
        for (MethodInfo m : ci.getAllMethods()) {
            if (!AutoListSwap.isSwapMethod(bc, m)) continue;
            ClassInfo rt = m.getReturnType();
            for (MethodInfo m2 : ci.getAllMethods()) {
                if (!AutoListSwap.isUnswapMethod(bc, m2, ci, rt)) continue;
                return new AutoListSwap(bc, ci, m, m2, null);
            }
            for (ConstructorInfo cs : ci.getDeclaredConstructors()) {
                if (!AutoListSwap.isUnswapConstructor(bc, cs, rt)) continue;
                return new AutoListSwap(bc, ci, m, null, cs);
            }
            return new AutoListSwap(bc, ci, m, null, null);
        }
        return null;
    }

    private static boolean shouldIgnore(BeanContext bc, ClassInfo ci) {
        return bc.hasAnnotation(BeanIgnore.class, ci) || ci.isNonStaticMemberClass();
    }

    private static boolean isSwapMethod(BeanContext bc, MethodInfo mi) {
        return mi.isNotDeprecated() && mi.isNotStatic() && mi.isVisible(bc.getBeanMethodVisibility()) && mi.hasName(SWAP_METHOD_NAMES) && mi.hasReturnTypeParent(List.class) && mi.hasFuzzyParamTypes(BeanSession.class) && !bc.hasAnnotation(BeanIgnore.class, mi);
    }

    private static boolean isUnswapMethod(BeanContext bc, MethodInfo mi, ClassInfo ci, ClassInfo rt) {
        return mi.isNotDeprecated() && mi.isStatic() && mi.isVisible(bc.getBeanMethodVisibility()) && mi.hasName(UNSWAP_METHOD_NAMES) && mi.hasFuzzyParamTypes(BeanSession.class, rt.inner()) && mi.hasReturnTypeParent(ci) && !bc.hasAnnotation(BeanIgnore.class, mi);
    }

    private static boolean isUnswapConstructor(BeanContext bc, ConstructorInfo cs, ClassInfo rt) {
        return cs.isNotDeprecated() && cs.isVisible(bc.getBeanConstructorVisibility()) && cs.hasMatchingParamTypes(rt) && !bc.hasAnnotation(BeanIgnore.class, cs);
    }

    private AutoListSwap(BeanContext bc, ClassInfo ci, MethodInfo swapMethod, MethodInfo unswapMethod, ConstructorInfo unswapConstructor) {
        super(ci.inner(), swapMethod.getReturnType().inner());
        this.swapMethod = bc.getBeanMethodVisibility().transform(swapMethod.inner());
        this.unswapMethod = unswapMethod == null ? null : bc.getBeanMethodVisibility().transform(unswapMethod.inner());
        this.unswapConstructor = unswapConstructor == null ? null : bc.getBeanConstructorVisibility().transform(unswapConstructor.inner());
    }

    @Override
    public List<?> swap(BeanSession session, Object o) throws SerializeException {
        try {
            return (List)this.swapMethod.invoke(o, ClassUtils.getMatchingArgs(this.swapMethod.getParameterTypes(), session));
        }
        catch (Exception e) {
            throw SerializeException.create(e);
        }
    }

    @Override
    public T unswap(BeanSession session, List<?> o, ClassMeta<?> hint) throws ParseException {
        try {
            if (this.unswapMethod != null) {
                return (T)this.unswapMethod.invoke(null, ClassUtils.getMatchingArgs(this.unswapMethod.getParameterTypes(), session, o));
            }
            if (this.unswapConstructor != null) {
                return (T)this.unswapConstructor.newInstance(o);
            }
            return super.unswap(session, o, hint);
        }
        catch (Exception e) {
            throw ParseException.create(e);
        }
    }
}

