/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.http.exception;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.apache.juneau.BasicRuntimeException;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.collections.AMap;
import org.apache.juneau.http.annotation.Response;
import org.apache.juneau.http.annotation.ResponseHeader;
import org.apache.juneau.http.annotation.ResponseStatus;
import org.apache.juneau.internal.FluentSetter;
import org.apache.juneau.internal.StringUtils;

@Response
public class HttpException
extends BasicRuntimeException {
    private static final long serialVersionUID = 1L;
    private int status;
    private AMap<String, Object> headers = AMap.of();

    public HttpException(Throwable cause, int status, String msg, Object ... args) {
        super(cause, HttpException.message(cause, msg, args), new Object[0]);
        this.status = status;
    }

    public HttpException(String msg) {
        this((Throwable)null, 0, msg, new Object[0]);
    }

    public HttpException(Throwable cause, int status) {
        this(cause, status, null, new Object[0]);
    }

    public HttpException(int status, String msg, Object ... args) {
        this(null, status, msg, args);
    }

    public Throwable getRootCause() {
        for (Throwable t = this; t != null; t = t.getCause()) {
            if (t instanceof HttpException || t instanceof InvocationTargetException) continue;
            return t;
        }
        return null;
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        for (Throwable e = this.getCause(); e != null; e = e.getCause()) {
            msg = e.getMessage();
            if (msg != null && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = e.getClass().getSimpleName();
            if (msg == null) {
                sb.append(StringUtils.format("\nCaused by ({0})", cls));
                continue;
            }
            sb.append(StringUtils.format("\nCaused by ({0}): {1}", cls, msg));
        }
        return sb.toString();
    }

    public int hashCode() {
        int i = 0;
        for (Throwable t = this; t != null; t = t.getCause()) {
            for (StackTraceElement e : t.getStackTrace()) {
                i ^= e.hashCode();
            }
        }
        return i;
    }

    public HttpException setStatus(int status) {
        this.status = status;
        return this;
    }

    @ResponseStatus
    public int getStatus() {
        return this.status;
    }

    @FluentSetter
    public HttpException header(String name, Object val) {
        this.headers.a(name, val);
        return this;
    }

    @ResponseHeader(value="*")
    @BeanIgnore
    public Map<String, Object> getHeaders() {
        return this.headers;
    }

    private static String message(Throwable cause, String msg, Object ... args) {
        if (msg == null && cause != null) {
            return StringUtils.firstNonEmpty(cause.getLocalizedMessage(), cause.getClass().getName());
        }
        return StringUtils.format(msg, args);
    }

    @Override
    public String toString() {
        return StringUtils.emptyIfNull(this.getLocalizedMessage());
    }
}

