/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client2;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import org.apache.http.Header;
import org.apache.http.HeaderIterator;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.NameValuePair;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.Configurable;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.concurrent.Cancellable;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.juneau.AddFlag;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.BeanSessionArgs;
import org.apache.juneau.DefaultFilteringOMap;
import org.apache.juneau.DetailLevel;
import org.apache.juneau.collections.AList;
import org.apache.juneau.collections.OMap;
import org.apache.juneau.html.HtmlDocSerializer;
import org.apache.juneau.html.HtmlParser;
import org.apache.juneau.html.HtmlSerializer;
import org.apache.juneau.html.HtmlStrippedDocSerializer;
import org.apache.juneau.http.BasicHeader;
import org.apache.juneau.http.BasicNameValuePair;
import org.apache.juneau.http.HeaderSupplier;
import org.apache.juneau.http.HttpResource;
import org.apache.juneau.http.NameValuePairSupplier;
import org.apache.juneau.http.SerializedHeader;
import org.apache.juneau.http.SerializedHttpEntity;
import org.apache.juneau.http.SerializedNameValuePair;
import org.apache.juneau.httppart.HttpPartSchema;
import org.apache.juneau.httppart.HttpPartSerializerSession;
import org.apache.juneau.httppart.HttpPartType;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.json.SimpleJsonParser;
import org.apache.juneau.json.SimpleJsonSerializer;
import org.apache.juneau.msgpack.MsgPackParser;
import org.apache.juneau.msgpack.MsgPackSerializer;
import org.apache.juneau.oapi.OpenApiParser;
import org.apache.juneau.oapi.OpenApiSerializer;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.plaintext.PlainTextParser;
import org.apache.juneau.plaintext.PlainTextSerializer;
import org.apache.juneau.rest.client2.BasicHttpEntityRequestBase;
import org.apache.juneau.rest.client2.BasicHttpRequestBase;
import org.apache.juneau.rest.client2.RestCallException;
import org.apache.juneau.rest.client2.RestCallInterceptor;
import org.apache.juneau.rest.client2.RestClient;
import org.apache.juneau.rest.client2.RestRequestCreated;
import org.apache.juneau.rest.client2.RestResponse;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.xml.XmlParser;
import org.apache.juneau.xml.XmlSerializer;

public class RestRequest
extends BeanSession
implements HttpUriRequest,
Configurable {
    private static final ContentType TEXT_PLAIN = ContentType.create((String)"text/plain");
    private final RestClient client;
    private final HttpRequestBase request;
    private RestResponse response;
    List<RestCallInterceptor> interceptors = new ArrayList<RestCallInterceptor>();
    private boolean ignoreErrors;
    private Object input;
    private boolean hasInput;
    private Serializer serializer;
    private Parser parser;
    private HttpPartSerializerSession partSerializer;
    private HttpPartSchema requestBodySchema;
    private URIBuilder uriBuilder;
    private List<NameValuePair> formData;
    private Predicate<Integer> errorCodes;
    private HttpHost target;
    private HttpContext context;

    protected RestRequest(RestClient client, URI uri, String method, boolean hasBody) throws RestCallException {
        super(client, BeanSessionArgs.DEFAULT);
        this.client = client;
        this.request = this.createInnerRequest(method, uri, hasBody);
        this.errorCodes = client.errorCodes;
        this.partSerializer = client.getPartSerializerSession();
        this.uriBuilder = new URIBuilder(this.request.getURI());
        this.ignoreErrors = client.ignoreErrors;
    }

    protected HttpRequestBase createInnerRequest(String method, URI uri, boolean hasBody) {
        RestRequestCreated req = hasBody ? new BasicHttpEntityRequestBase(this, method) : new BasicHttpRequestBase(this, method);
        req.setURI(uri);
        return req;
    }

    public RestRequest json() {
        return this.serializer(JsonSerializer.class).parser(JsonParser.class);
    }

    public RestRequest simpleJson() {
        return this.serializer(SimpleJsonSerializer.class).parser(SimpleJsonParser.class);
    }

    public RestRequest xml() {
        return this.serializer(XmlSerializer.class).parser(XmlParser.class);
    }

    public RestRequest html() {
        return this.serializer(HtmlSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest htmlDoc() {
        return this.serializer(HtmlDocSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest htmlStrippedDoc() {
        return this.serializer(HtmlStrippedDocSerializer.class).parser(HtmlParser.class);
    }

    public RestRequest plainText() {
        return this.serializer(PlainTextSerializer.class).parser(PlainTextParser.class);
    }

    public RestRequest msgPack() {
        return this.serializer(MsgPackSerializer.class).parser(MsgPackParser.class);
    }

    public RestRequest uon() {
        return this.serializer(UonSerializer.class).parser(UonParser.class);
    }

    public RestRequest urlEnc() {
        return this.serializer(UrlEncodingSerializer.class).parser(UrlEncodingParser.class);
    }

    public RestRequest openApi() {
        return this.serializer(OpenApiSerializer.class).parser(OpenApiParser.class);
    }

    public RestRequest serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestRequest serializer(Class<? extends Serializer> serializer) {
        this.serializer = this.client.getInstance(serializer);
        return this;
    }

    public RestRequest parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public RestRequest parser(Class<? extends Parser> parser) {
        this.parser = this.client.getInstance(parser);
        return this;
    }

    public RestRequest errorCodes(Predicate<Integer> value) {
        this.errorCodes = value;
        return this;
    }

    public RestRequest interceptors(RestCallInterceptor ... interceptors) throws RestCallException {
        try {
            for (RestCallInterceptor i : interceptors) {
                this.interceptors.add(i);
                i.onInit(this);
            }
        }
        catch (RuntimeException | RestCallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RestCallException(null, e, "Interceptor threw an exception on init.", new Object[0]);
        }
        return this;
    }

    public RestRequest ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public RestRequest debug() throws RestCallException {
        this.header("Debug", true);
        return this;
    }

    @Override
    public boolean isDebug() {
        return this.getHeader("Debug", "false").equalsIgnoreCase("true");
    }

    public RestRequest target(HttpHost target) {
        this.target = target;
        return this;
    }

    public RestRequest context(HttpContext context) {
        this.context = context;
        return this;
    }

    public RestRequest uri(Object uri) throws RestCallException {
        URI x = this.client.toURI(uri, null);
        if (x.getScheme() != null) {
            this.uriBuilder.setScheme(x.getScheme());
        }
        if (x.getHost() != null) {
            this.uriBuilder.setHost(x.getHost());
        }
        if (x.getPort() != -1) {
            this.uriBuilder.setPort(x.getPort());
        }
        if (x.getUserInfo() != null) {
            this.uriBuilder.setUserInfo(x.getUserInfo());
        }
        if (x.getFragment() != null) {
            this.uriBuilder.setFragment(x.getFragment());
        }
        if (x.getQuery() != null) {
            this.uriBuilder.setCustomQuery(x.getQuery());
        }
        this.uriBuilder.setPath(x.getPath());
        return this;
    }

    public RestRequest scheme(String scheme) {
        this.uriBuilder.setScheme(scheme);
        return this;
    }

    public RestRequest host(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public RestRequest port(int port) {
        this.uriBuilder.setPort(port);
        return this;
    }

    public RestRequest userInfo(String userInfo) {
        this.uriBuilder.setUserInfo(userInfo);
        return this;
    }

    public RestRequest userInfo(String username, String password) {
        this.uriBuilder.setUserInfo(username, password);
        return this;
    }

    public RestRequest fragment(String fragment) {
        this.uriBuilder.setFragment(fragment);
        return this;
    }

    public RestRequest path(String name, Object value) throws RestCallException {
        return this.paths(RestRequest.serializedNameValuePair(name, value, HttpPartType.PATH, this.partSerializer, null, null));
    }

    public RestRequest path(NameValuePair pair) throws RestCallException {
        return this.paths(pair);
    }

    public RestRequest path(String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.paths(RestRequest.serializedNameValuePair(name, value, HttpPartType.PATH, this.partSerializer, schema, null));
    }

    public RestRequest paths(Object ... params) throws RestCallException {
        for (Object o : params) {
            if (BasicNameValuePair.canCast(o)) {
                this.innerPath(BasicNameValuePair.cast(o));
                continue;
            }
            if (o instanceof NameValuePairSupplier) {
                for (NameValuePair nameValuePair : (NameValuePairSupplier)o) {
                    this.innerPath(nameValuePair);
                }
                continue;
            }
            if (o instanceof Collection) {
                for (Object e : (Collection)o) {
                    this.innerPath(BasicNameValuePair.cast(e));
                }
                continue;
            }
            if (o != null && o.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    this.innerPath(BasicNameValuePair.cast(Array.get(o, i)));
                }
                continue;
            }
            if (o instanceof Map) {
                for (Map.Entry<Object, Object> entry : RestRequest.toMap(o).entrySet()) {
                    this.innerPath(RestRequest.serializedNameValuePair(entry.getKey(), entry.getValue(), HttpPartType.PATH, this.partSerializer, null, null));
                }
                continue;
            }
            if (this.isBean(o)) {
                for (Map.Entry<String, Object> entry : this.toBeanMap(o).entrySet()) {
                    this.innerPath(RestRequest.serializedNameValuePair(entry.getKey(), entry.getValue(), HttpPartType.PATH, this.partSerializer, null, null));
                }
                continue;
            }
            if (o == null) continue;
            throw new RestCallException(null, null, "Invalid type passed to paths(): {0}", ClassUtils.className(o));
        }
        return this;
    }

    public RestRequest pathPairs(Object ... pairs) throws RestCallException {
        if (pairs.length % 2 != 0) {
            throw new RestCallException(null, null, "Odd number of parameters passed into pathPairs()", new Object[0]);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.paths(RestRequest.serializedNameValuePair(pairs[i], pairs[i + 1], HttpPartType.PATH, this.partSerializer, null, null));
        }
        return this;
    }

    RestRequest pathArg(String name, Object value, HttpPartSchema schema, HttpPartSerializerSession serializer) throws RestCallException {
        boolean isMulti;
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairSupplier || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            return this.innerPath(RestRequest.serializedNameValuePair(name, value, HttpPartType.PATH, serializer, schema, null));
        }
        if (BasicNameValuePair.canCast(value)) {
            this.innerPath(BasicNameValuePair.cast(value));
        } else if (value instanceof NameValuePairSupplier) {
            for (NameValuePair o : (NameValuePairSupplier)value) {
                this.innerPath(BasicNameValuePair.cast(o));
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                this.innerPath(BasicNameValuePair.cast(o));
            }
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                this.innerPath(BasicNameValuePair.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            for (Map.Entry<Object, Object> p : RestRequest.toMap(value).entrySet()) {
                this.innerPath(RestRequest.serializedNameValuePair(p.getKey(), p.getValue(), HttpPartType.PATH, serializer, schema, null));
            }
        } else if (this.isBean(value)) {
            for (Map.Entry<String, Object> p : this.toBeanMap(value).entrySet()) {
                this.innerPath(RestRequest.serializedNameValuePair(p.getKey(), p.getValue(), HttpPartType.PATH, serializer, schema, null));
            }
        } else if (value != null) {
            throw new RestCallException(null, null, "Invalid value type for path arg ''{0}'': {1}", name, ClassUtils.className(value));
        }
        return this;
    }

    private RestRequest innerPath(NameValuePair param) throws RestCallException {
        String path = this.uriBuilder.getPath();
        String name = param.getName();
        String value = param.getValue();
        String var = "{" + name + "}";
        if (path.indexOf(var) == -1 && !name.equals("/*")) {
            throw new RestCallException(null, null, "Path variable {" + name + "} was not found in path.", new Object[0]);
        }
        String p = null;
        p = name.equals("/*") ? path.replaceAll("\\/\\*$", "/" + value) : path.replace(var, String.valueOf(value));
        this.uriBuilder.setPath(p);
        return this;
    }

    public RestRequest query(AddFlag flag, String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.queries(flag, RestRequest.serializedNameValuePair(name, value, HttpPartType.QUERY, this.partSerializer, schema, EnumSet.of(flag)));
    }

    public RestRequest query(String name, Object value) throws RestCallException {
        return this.queries(RestRequest.serializedNameValuePair(name, value, HttpPartType.QUERY, this.partSerializer, null, null));
    }

    public RestRequest query(NameValuePair pair) throws RestCallException {
        return this.queries(pair);
    }

    public RestRequest query(String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.queries(RestRequest.serializedNameValuePair(name, value, HttpPartType.QUERY, this.partSerializer, schema, null));
    }

    public RestRequest query(AddFlag flag, String name, Object value) throws RestCallException {
        return this.queries(flag, RestRequest.serializedNameValuePair(name, value, HttpPartType.QUERY, this.partSerializer, null, EnumSet.of(flag)));
    }

    public RestRequest queries(Object ... params) throws RestCallException {
        return this.queries(AddFlag.APPEND, params);
    }

    public RestRequest queries(AddFlag flag, Object ... params) throws RestCallException {
        ArrayList<NameValuePair> l = new ArrayList<NameValuePair>();
        for (Object o : params) {
            if (BasicNameValuePair.canCast(o)) {
                l.add(BasicNameValuePair.cast(o));
                continue;
            }
            if (o instanceof NameValuePairSupplier) {
                for (NameValuePair nameValuePair : (NameValuePairSupplier)o) {
                    l.add(nameValuePair);
                }
                continue;
            }
            if (o instanceof Collection) {
                for (Object e : (Collection)o) {
                    l.add(BasicNameValuePair.cast(e));
                }
                continue;
            }
            if (o != null && o.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    l.add(BasicNameValuePair.cast(Array.get(o, i)));
                }
                continue;
            }
            if (o instanceof Map) {
                for (Map.Entry<Object, Object> entry : RestRequest.toMap(o).entrySet()) {
                    l.add(RestRequest.serializedNameValuePair(entry.getKey(), entry.getValue(), HttpPartType.QUERY, this.partSerializer, null, EnumSet.of(flag)));
                }
                continue;
            }
            if (this.isBean(o)) {
                for (Map.Entry<String, Object> entry : this.toBeanMap(o).entrySet()) {
                    l.add(RestRequest.serializedNameValuePair(entry.getKey(), entry.getValue(), HttpPartType.QUERY, this.partSerializer, null, EnumSet.of(flag)));
                }
                continue;
            }
            if (o == null) continue;
            throw new RestCallException(null, null, "Invalid type passed to queries(): {0}", ClassUtils.className(o));
        }
        return this.innerQuery(EnumSet.of(flag), l);
    }

    public RestRequest queryPairs(Object ... pairs) throws RestCallException {
        if (pairs.length % 2 != 0) {
            throw new RestCallException(null, null, "Odd number of parameters passed into queryPairs()", new Object[0]);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.queries(RestRequest.serializedNameValuePair(pairs[i], pairs[i + 1], HttpPartType.QUERY, this.partSerializer, null, null));
        }
        return this;
    }

    public RestRequest queryCustom(Object value) throws RestCallException {
        try {
            String q = null;
            q = value instanceof Reader ? IOUtils.read((Reader)value) : (value instanceof InputStream ? IOUtils.read((InputStream)value) : StringUtils.stringify(value));
            this.uriBuilder.setCustomQuery(q);
        }
        catch (IOException e) {
            throw new RestCallException(null, e, "Could not read custom query.", new Object[0]);
        }
        return this;
    }

    RestRequest queryArg(EnumSet<AddFlag> flags, String name, Object value, HttpPartSchema schema, HttpPartSerializerSession serializer) throws RestCallException {
        boolean isMulti;
        flags = AddFlag.orDefault(flags);
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairSupplier || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            return this.innerQuery(flags, AList.of(new NameValuePair[]{RestRequest.serializedNameValuePair(name, value, HttpPartType.QUERY, serializer, schema, flags)}));
        }
        AList<NameValuePair> l = AList.of();
        if (BasicNameValuePair.canCast(value)) {
            l.add(BasicNameValuePair.cast(value));
        } else if (value instanceof NameValuePairSupplier) {
            for (NameValuePair o : (NameValuePairSupplier)value) {
                l.add(BasicNameValuePair.cast(o));
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                l.add(BasicNameValuePair.cast(o));
            }
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(BasicNameValuePair.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            for (Map.Entry<Object, Object> e : RestRequest.toMap(value).entrySet()) {
                l.add(RestRequest.serializedNameValuePair(e.getKey(), e.getValue(), HttpPartType.QUERY, serializer, schema, flags));
            }
        } else if (this.isBean(value)) {
            for (Map.Entry<String, Object> e : this.toBeanMap(value).entrySet()) {
                l.add(RestRequest.serializedNameValuePair(e.getKey(), e.getValue(), HttpPartType.QUERY, serializer, schema, flags));
            }
        } else {
            return this.queryCustom(value);
        }
        return this.innerQuery(flags, l);
    }

    private RestRequest innerQuery(EnumSet<AddFlag> flags, List<NameValuePair> params) {
        flags = AddFlag.orDefault(flags);
        params.removeIf(x -> x.getValue() == null);
        if (flags.contains((Object)AddFlag.SKIP_IF_EMPTY)) {
            params.removeIf(x -> StringUtils.isEmpty(x.getValue()));
        }
        if (flags.contains((Object)AddFlag.REPLACE)) {
            List l = this.uriBuilder.getQueryParams();
            for (NameValuePair p : params) {
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    if (!((NameValuePair)i.next()).getName().equals(p.getName())) continue;
                    i.remove();
                }
            }
            l.addAll(params);
            this.uriBuilder.setParameters(l);
        } else if (flags.contains((Object)AddFlag.PREPEND)) {
            List l = this.uriBuilder.getQueryParams();
            l.addAll(0, params);
            this.uriBuilder.setParameters(l);
        } else {
            this.uriBuilder.addParameters(params);
        }
        return this;
    }

    public RestRequest formData(AddFlag flag, String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.formDatas(flag, RestRequest.serializedNameValuePair(name, value, HttpPartType.FORMDATA, this.partSerializer, schema, EnumSet.of(flag)));
    }

    public RestRequest formData(String name, Object value) throws RestCallException {
        return this.formDatas(RestRequest.serializedNameValuePair(name, value, HttpPartType.FORMDATA, this.partSerializer, null, null));
    }

    public RestRequest formData(NameValuePair pair) throws RestCallException {
        return this.formDatas(pair);
    }

    public RestRequest formData(String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.formDatas(RestRequest.serializedNameValuePair(name, value, HttpPartType.FORMDATA, this.partSerializer, schema, null));
    }

    public RestRequest formData(AddFlag flag, String name, Object value) throws RestCallException {
        return this.formDatas(flag, RestRequest.serializedNameValuePair(name, value, HttpPartType.FORMDATA, this.partSerializer, null, EnumSet.of(flag)));
    }

    public RestRequest formDatas(Object ... params) throws RestCallException {
        return this.formDatas(AddFlag.APPEND, params);
    }

    public RestRequest formDatas(AddFlag flag, Object ... params) throws RestCallException {
        ArrayList<NameValuePair> l = new ArrayList<NameValuePair>();
        for (Object o : params) {
            if (BasicNameValuePair.canCast(o)) {
                l.add(BasicNameValuePair.cast(o));
                continue;
            }
            if (o instanceof NameValuePairSupplier) {
                for (NameValuePair nameValuePair : (NameValuePairSupplier)o) {
                    l.add(nameValuePair);
                }
                continue;
            }
            if (o instanceof Collection) {
                for (Object e : (Collection)o) {
                    l.add(BasicNameValuePair.cast(e));
                }
                continue;
            }
            if (o != null && o.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    l.add(BasicNameValuePair.cast(Array.get(o, i)));
                }
                continue;
            }
            if (o instanceof Map) {
                for (Map.Entry<Object, Object> entry : RestRequest.toMap(o).entrySet()) {
                    l.add(RestRequest.serializedNameValuePair(entry.getKey(), entry.getValue(), HttpPartType.FORMDATA, this.partSerializer, null, EnumSet.of(flag)));
                }
                continue;
            }
            if (this.isBean(o)) {
                for (Map.Entry<String, Object> entry : this.toBeanMap(o).entrySet()) {
                    l.add(RestRequest.serializedNameValuePair(entry.getKey(), entry.getValue(), HttpPartType.FORMDATA, this.partSerializer, null, EnumSet.of(flag)));
                }
                continue;
            }
            if (o == null) continue;
            throw new RestCallException(null, null, "Invalid type passed to formDatas(): {0}", ClassUtils.className(o));
        }
        return this.innerFormData(EnumSet.of(flag), l);
    }

    public RestRequest formDataPairs(Object ... pairs) throws RestCallException {
        if (pairs.length % 2 != 0) {
            throw new RestCallException(null, null, "Odd number of parameters passed into formDataPairs()", new Object[0]);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            this.formDatas(RestRequest.serializedNameValuePair(pairs[i], pairs[i + 1], HttpPartType.FORMDATA, this.partSerializer, null, null));
        }
        return this;
    }

    public RestRequest formDataCustom(Object value) throws RestCallException {
        this.contentType("application/x-www-form-urlencoded");
        this.body(value instanceof CharSequence ? new StringReader(value.toString()) : value);
        return this;
    }

    RestRequest formDataArg(EnumSet<AddFlag> flags, String name, Object value, HttpPartSchema schema, HttpPartSerializerSession serializer) throws RestCallException {
        boolean isMulti;
        flags = AddFlag.orDefault(flags);
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof NameValuePairSupplier || RestRequest.isNameValuePairArray(value);
        if (!isMulti) {
            return this.innerFormData(flags, AList.of(new NameValuePair[]{RestRequest.serializedNameValuePair(name, value, HttpPartType.FORMDATA, serializer, schema, flags)}));
        }
        AList<NameValuePair> l = AList.of();
        if (BasicNameValuePair.canCast(value)) {
            l.add(BasicNameValuePair.cast(value));
        } else if (value instanceof NameValuePairSupplier) {
            for (NameValuePair o : (NameValuePairSupplier)value) {
                l.add(BasicNameValuePair.cast(o));
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                l.add(BasicNameValuePair.cast(o));
            }
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(BasicNameValuePair.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            for (Map.Entry<Object, Object> e : RestRequest.toMap(value).entrySet()) {
                l.add(RestRequest.serializedNameValuePair(e.getKey(), e.getValue(), HttpPartType.FORMDATA, serializer, schema, flags));
            }
        } else if (this.isBean(value)) {
            for (Map.Entry<String, Object> e : this.toBeanMap(value).entrySet()) {
                l.add(RestRequest.serializedNameValuePair(e.getKey(), e.getValue(), HttpPartType.FORMDATA, serializer, schema, flags));
            }
        } else {
            return this.formDataCustom(value);
        }
        return this.innerFormData(flags, l);
    }

    private RestRequest innerFormData(EnumSet<AddFlag> flags, List<NameValuePair> params) {
        this.input = null;
        flags = AddFlag.orDefault(flags);
        params.removeIf(x -> x.getValue() == null);
        if (flags.contains((Object)AddFlag.SKIP_IF_EMPTY)) {
            params.removeIf(x -> StringUtils.isEmpty(x.getValue()));
        }
        if (this.formData == null) {
            this.formData = new ArrayList<NameValuePair>();
        }
        if (flags.contains((Object)AddFlag.REPLACE)) {
            for (NameValuePair p : params) {
                Iterator<NameValuePair> i = this.formData.iterator();
                while (i.hasNext()) {
                    if (!i.next().getName().equals(p.getName())) continue;
                    i.remove();
                }
            }
            this.formData.addAll(params);
        } else if (flags.contains((Object)AddFlag.PREPEND)) {
            this.formData.addAll(0, params);
        } else {
            this.formData.addAll(params);
        }
        return this;
    }

    public RestRequest body(Object input) throws RestCallException {
        this.input = input;
        this.hasInput = true;
        this.formData = null;
        return this;
    }

    public RestRequest bodyString(Object input) throws RestCallException {
        return this.body(input == null ? null : new StringReader(StringUtils.stringify(input)));
    }

    public RestRequest body(Object input, HttpPartSchema schema) throws RestCallException {
        this.input = input;
        this.hasInput = true;
        this.formData = null;
        this.requestBodySchema = schema;
        return this;
    }

    public RestRequest header(AddFlag flag, String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.headers(flag, RestRequest.serializedHeader(name, value, this.partSerializer, schema, EnumSet.of(flag)));
    }

    public RestRequest header(String name, Object value) throws RestCallException {
        return this.headers(RestRequest.serializedHeader(name, value, this.partSerializer, null, null));
    }

    public RestRequest header(String name, Object value, HttpPartSchema schema) throws RestCallException {
        return this.headers(RestRequest.serializedHeader(name, value, this.partSerializer, schema, null));
    }

    public RestRequest header(AddFlag flag, String name, Object value) throws RestCallException {
        return this.headers(flag, RestRequest.serializedHeader(name, value, this.partSerializer, null, EnumSet.of(flag)));
    }

    public RestRequest header(Header header) throws RestCallException {
        return this.headers(header);
    }

    public RestRequest headers(Object ... headers) throws RestCallException {
        return this.headers(AddFlag.APPEND, headers);
    }

    public RestRequest headers(AddFlag flag, Object ... headers) throws RestCallException {
        ArrayList<Header> l = new ArrayList<Header>();
        for (Object o : headers) {
            if (BasicHeader.canCast(o)) {
                l.add(BasicHeader.cast(o));
                continue;
            }
            if (o instanceof HeaderSupplier) {
                for (Header header : (HeaderSupplier)o) {
                    l.add(header);
                }
                continue;
            }
            if (o instanceof Collection) {
                for (Object e : (Collection)o) {
                    l.add(BasicHeader.cast(e));
                }
                continue;
            }
            if (o != null && o.getClass().isArray()) {
                for (int i = 0; i < Array.getLength(o); ++i) {
                    l.add(BasicHeader.cast(Array.get(o, i)));
                }
                continue;
            }
            if (o instanceof Map) {
                for (Map.Entry<Object, Object> entry : RestRequest.toMap(o).entrySet()) {
                    l.add(RestRequest.serializedHeader(entry.getKey(), entry.getValue(), this.partSerializer, null, EnumSet.of(flag)));
                }
                continue;
            }
            if (this.isBean(o)) {
                for (Map.Entry<String, Object> entry : this.toBeanMap(o).entrySet()) {
                    l.add(RestRequest.serializedHeader(entry.getKey(), entry.getValue(), this.partSerializer, null, EnumSet.of(flag)));
                }
                continue;
            }
            if (o == null) continue;
            throw new RestCallException(null, null, "Invalid type passed to headers(): {0}", ClassUtils.className(o));
        }
        return this.innerHeaders(EnumSet.of(flag), l);
    }

    public RestRequest headerPairs(Object ... pairs) throws RestCallException {
        ArrayList<Header> l = new ArrayList<Header>();
        if (pairs.length % 2 != 0) {
            throw new RestCallException(null, null, "Odd number of parameters passed into headerPairs()", new Object[0]);
        }
        for (int i = 0; i < pairs.length; i += 2) {
            l.add(RestRequest.serializedHeader(pairs[i], pairs[i + 1], this.partSerializer, null, null));
        }
        return this.innerHeaders(EnumSet.of(AddFlag.APPEND), l);
    }

    RestRequest headerArg(EnumSet<AddFlag> flags, String name, Object value, HttpPartSchema schema, HttpPartSerializerSession serializer) throws RestCallException {
        boolean isMulti;
        flags = AddFlag.orDefault(flags);
        boolean bl = isMulti = StringUtils.isEmpty(name) || "*".equals(name) || value instanceof HeaderSupplier || RestRequest.isHeaderArray(value);
        if (!isMulti) {
            return this.innerHeaders(flags, AList.of(new Header[]{RestRequest.serializedHeader(name, value, serializer, schema, flags)}));
        }
        AList<Header> l = AList.of();
        if (BasicHeader.canCast(value)) {
            l.add(BasicHeader.cast(value));
        } else if (value instanceof HeaderSupplier) {
            for (Header o : (HeaderSupplier)value) {
                l.add(BasicHeader.cast(o));
            }
        } else if (value instanceof Collection) {
            for (Object o : (Collection)value) {
                l.add(BasicHeader.cast(o));
            }
        } else if (value != null && value.getClass().isArray()) {
            for (int i = 0; i < Array.getLength(value); ++i) {
                l.add(BasicHeader.cast(Array.get(value, i)));
            }
        } else if (value instanceof Map) {
            for (Map.Entry<Object, Object> e : RestRequest.toMap(value).entrySet()) {
                l.add(RestRequest.serializedHeader(e.getKey(), e.getValue(), serializer, schema, flags));
            }
        } else if (this.isBean(value)) {
            for (Map.Entry<String, Object> e : this.toBeanMap(value).entrySet()) {
                l.add(RestRequest.serializedHeader(e.getKey(), e.getValue(), serializer, schema, flags));
            }
        } else if (value != null) {
            throw new RestCallException(null, null, "Invalid value type for header arg ''{0}'': {1}", name, ClassUtils.className(value));
        }
        return this.innerHeaders(flags, l);
    }

    private RestRequest innerHeaders(EnumSet<AddFlag> flags, Collection<Header> headers) {
        flags = AddFlag.orDefault(flags);
        headers.removeIf(x -> x.getValue() == null);
        if (flags.contains((Object)AddFlag.SKIP_IF_EMPTY)) {
            headers.removeIf(x -> StringUtils.isEmpty(x.getValue()));
        }
        if (flags.contains((Object)AddFlag.REPLACE)) {
            for (Header h : headers) {
                this.removeHeaders(h.getName());
            }
        } else if (flags.contains((Object)AddFlag.PREPEND)) {
            for (Header h : AList.of(headers)) {
                for (Header h2 : this.getHeaders(h.getName())) {
                    headers.add(h2);
                }
                this.removeHeaders(h.getName());
            }
        }
        for (Header h : headers) {
            this.addHeader(h);
        }
        return this;
    }

    public String getHeader(String name) {
        return this.getHeader(name, null);
    }

    public String getHeader(String name, String def) {
        Header h = this.getLastHeader(name);
        return h == null ? def : h.getValue();
    }

    public RestRequest accept(Object value) throws RestCallException {
        return this.header("Accept", value);
    }

    public RestRequest acceptCharset(Object value) throws RestCallException {
        return this.header("Accept-Charset", value);
    }

    public RestRequest acceptEncoding(Object value) throws RestCallException {
        return this.header("Accept-Encoding", value);
    }

    public RestRequest acceptLanguage(Object value) throws RestCallException {
        return this.header("Accept-Language", value);
    }

    public RestRequest authorization(Object value) throws RestCallException {
        return this.header("Authorization", value);
    }

    public RestRequest cacheControl(Object value) throws RestCallException {
        return this.header("Cache-Control", value);
    }

    public RestRequest connection(Object value) throws RestCallException {
        return this.header("Connection", value);
    }

    public RestRequest contentLength(Object value) throws RestCallException {
        return this.header("Content-Length", value);
    }

    public RestRequest contentType(Object value) throws RestCallException {
        return this.header("Content-Type", value);
    }

    public RestRequest contentEncoding(Object value) throws RestCallException {
        return this.header("Content-Encoding", value);
    }

    public RestRequest date(Object value) throws RestCallException {
        return this.header("Date", value);
    }

    public RestRequest expect(Object value) throws RestCallException {
        return this.header("Expect", value);
    }

    public RestRequest forwarded(Object value) throws RestCallException {
        return this.header("Forwarded", value);
    }

    public RestRequest from(Object value) throws RestCallException {
        return this.header("From", value);
    }

    public RestRequest hostHeader(Object value) throws RestCallException {
        return this.header("Host", value);
    }

    public RestRequest ifMatch(Object value) throws RestCallException {
        return this.header("If-Match", value);
    }

    public RestRequest ifModifiedSince(Object value) throws RestCallException {
        return this.header("If-Modified-Since", value);
    }

    public RestRequest ifNoneMatch(Object value) throws RestCallException {
        return this.header("If-None-Match", value);
    }

    public RestRequest ifRange(Object value) throws RestCallException {
        return this.header("If-Range", value);
    }

    public RestRequest ifUnmodifiedSince(Object value) throws RestCallException {
        return this.header("If-Unmodified-Since", value);
    }

    public RestRequest maxForwards(Object value) throws RestCallException {
        return this.header("Max-Forwards", value);
    }

    public RestRequest noTrace() throws RestCallException {
        return this.header("No-Trace", true);
    }

    public RestRequest origin(Object value) throws RestCallException {
        return this.header("Origin", value);
    }

    public RestRequest pragma(Object value) throws RestCallException {
        return this.header("Pragma", value);
    }

    public RestRequest proxyAuthorization(Object value) throws RestCallException {
        return this.header("Proxy-Authorization", value);
    }

    public RestRequest range(Object value) throws RestCallException {
        return this.header("Range", value);
    }

    public RestRequest referer(Object value) throws RestCallException {
        return this.header("Referer", value);
    }

    public RestRequest te(Object value) throws RestCallException {
        return this.header("TE", value);
    }

    public RestRequest userAgent(Object value) throws RestCallException {
        return this.header("User-Agent", value);
    }

    public RestRequest upgrade(Object value) throws RestCallException {
        return this.header("Upgrade", value);
    }

    public RestRequest via(Object value) throws RestCallException {
        return this.header("Via", value);
    }

    public RestRequest warning(Object value) throws RestCallException {
        return this.header("Warning", value);
    }

    public RestRequest clientVersion(Object value) throws RestCallException {
        return this.header("X-Client-Version", value);
    }

    public RestResponse run() throws RestCallException {
        if (this.response != null) {
            throw new RestCallException(this.response, null, "run() already called.", new Object[0]);
        }
        try {
            HttpEntityEnclosingRequestBase request2 = this.request instanceof HttpEntityEnclosingRequestBase ? (HttpEntityEnclosingRequestBase)this.request : null;
            this.request.setURI(this.uriBuilder.build());
            Header h = this.getLastHeader("Content-Type");
            String contentType = h == null ? null : h.getValue();
            Serializer serializer = this.serializer;
            if (serializer == null) {
                serializer = this.client.getMatchingSerializer(contentType);
            }
            if (contentType == null && serializer != null) {
                contentType = serializer.getPrimaryMediaType().toString();
            }
            String accept = (h = this.getLastHeader("Accept")) == null ? null : h.getValue();
            Parser parser = this.parser;
            if (parser == null) {
                parser = this.client.getMatchingParser(accept);
            }
            if (accept == null && parser != null) {
                this.setHeader("Accept", parser.getPrimaryMediaType().toString());
            }
            if (this.hasInput || this.formData != null) {
                if (request2 == null) {
                    throw new RestCallException(null, null, "Method does not support content entity.  Method={0}, URI={1}", this.getMethod(), this.getURI());
                }
                Object input2 = this.input;
                if (input2 instanceof Supplier) {
                    input2 = ((Supplier)this.input).get();
                }
                Object entity = null;
                if (this.formData != null) {
                    entity = new UrlEncodedFormEntity(this.formData);
                } else if (input2 instanceof NameValuePairSupplier) {
                    entity = new UrlEncodedFormEntity((Iterable)((NameValuePairSupplier)input2));
                } else if (input2 instanceof HttpResource) {
                    HttpResource r = (HttpResource)input2;
                    this.headers(r.getHeaders());
                    entity = (HttpEntity)input2;
                } else if (input2 instanceof HttpEntity) {
                    entity = (HttpEntity)input2;
                } else if (input2 instanceof Reader) {
                    entity = new StringEntity(IOUtils.read((Reader)input2), this.getRequestContentType(TEXT_PLAIN));
                } else if (input2 instanceof InputStream) {
                    entity = new InputStreamEntity((InputStream)input2, this.getRequestContentType(ContentType.APPLICATION_OCTET_STREAM));
                } else if (serializer != null) {
                    entity = SerializedHttpEntity.of(input2, serializer).schema(this.requestBodySchema).contentType(contentType);
                } else {
                    if (input2 == null) {
                        input2 = "";
                    }
                    entity = new StringEntity(BeanContext.DEFAULT.getClassMetaForObject(input2).toString(input2), this.getRequestContentType(TEXT_PLAIN));
                }
                request2.setEntity((HttpEntity)entity);
            }
            this.response = this.client.createResponse(this, this.client.run(this.target, (HttpRequest)this.request, this.context), parser);
            if (this.isDebug() || this.client.logRequests == DetailLevel.FULL) {
                this.response.cacheBody();
            }
            for (RestCallInterceptor rci : this.interceptors) {
                rci.onConnect(this, this.response);
            }
            this.client.onConnect(this, this.response);
            String method = this.getMethod();
            int sc = this.response.getStatusCode();
            if (this.errorCodes.test(sc) && !this.ignoreErrors) {
                throw new RestCallException(this.response, null, "HTTP method ''{0}'' call to ''{1}'' caused response code ''{2}, {3}''.\nResponse: \n{4}", method, this.getURI(), sc, this.response.getReasonPhrase(), this.response.getBody().asAbbreviatedString(1000));
            }
        }
        catch (RuntimeException | RestCallException e) {
            if (this.response != null) {
                this.response.close();
            }
            throw e;
        }
        catch (Exception e) {
            if (this.response != null) {
                this.response.close();
            }
            throw new RestCallException(this.response, e, "Call failed.", new Object[0]);
        }
        return this.response;
    }

    public Future<RestResponse> runFuture() throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<RestResponse>(){

            @Override
            public RestResponse call() throws Exception {
                return RestRequest.this.run();
            }
        });
    }

    public RestResponse complete() throws RestCallException {
        return this.run().consume();
    }

    public Future<RestResponse> completeFuture() throws RestCallException {
        return this.client.getExecutorService().submit(new Callable<RestResponse>(){

            @Override
            public RestResponse call() throws Exception {
                return RestRequest.this.complete();
            }
        });
    }

    public boolean hasHttpEntity() {
        return this.request instanceof HttpEntityEnclosingRequestBase;
    }

    public HttpEntity getHttpEntity() {
        return this.hasHttpEntity() ? ((HttpEntityEnclosingRequestBase)this.request).getEntity() : null;
    }

    public RestRequest log(Level level, Throwable t, String msg, Object ... args) {
        this.client.log(level, t, msg, args);
        return this;
    }

    public RestRequest log(Level level, String msg, Object ... args) {
        this.client.log(level, msg, args);
        return this;
    }

    public RestRequest config(RequestConfig value) {
        this.request.setConfig(value);
        return this;
    }

    public RestRequest cancellable(Cancellable cancellable) {
        this.request.setCancellable(cancellable);
        return this;
    }

    public RestRequest protocolVersion(ProtocolVersion version) {
        this.request.setProtocolVersion(version);
        return this;
    }

    public RestRequest completed() {
        this.request.completed();
        return this;
    }

    public String getMethod() {
        return this.request.getMethod();
    }

    public URI getURI() {
        return this.request.getURI();
    }

    public String getUri() {
        return this.getURI().toString();
    }

    public void abort() throws UnsupportedOperationException {
        this.request.abort();
    }

    public boolean isAborted() {
        return this.request.isAborted();
    }

    public RequestLine getRequestLine() {
        return this.request.getRequestLine();
    }

    public ProtocolVersion getProtocolVersion() {
        return this.request.getProtocolVersion();
    }

    public boolean containsHeader(String name) {
        return this.request.containsHeader(name);
    }

    public Header[] getHeaders(String name) {
        return this.request.getHeaders(name);
    }

    public Header getFirstHeader(String name) {
        return this.request.getFirstHeader(name);
    }

    public Header getLastHeader(String name) {
        return this.request.getLastHeader(name);
    }

    public Header[] getAllHeaders() {
        return this.request.getAllHeaders();
    }

    public void addHeader(Header header) {
        this.request.addHeader(header);
    }

    public void addHeader(String name, String value) {
        this.request.addHeader(name, value);
    }

    public void setHeader(Header header) {
        this.request.setHeader(header);
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    public void setHeaders(Header[] headers) {
        this.request.setHeaders(headers);
    }

    public void removeHeader(Header header) {
        this.request.removeHeader(header);
    }

    public void removeHeaders(String name) {
        this.request.removeHeaders(name);
    }

    public HeaderIterator headerIterator() {
        return this.request.headerIterator();
    }

    public HeaderIterator headerIterator(String name) {
        return this.request.headerIterator(name);
    }

    @Deprecated
    public HttpParams getParams() {
        return this.request.getParams();
    }

    @Deprecated
    public void setParams(HttpParams params) {
        this.request.setParams(params);
    }

    public RequestConfig getConfig() {
        return this.request.getConfig();
    }

    private ContentType getRequestContentType(ContentType def) {
        String s;
        Header h = this.request.getFirstHeader("Content-Type");
        if (h != null && !StringUtils.isEmpty(s = h.getValue())) {
            return ContentType.create((String)s);
        }
        return def;
    }

    @Override
    public OMap getProperties() {
        return super.getProperties();
    }

    private static Map<Object, Object> toMap(Object o) {
        return (Map)o;
    }

    private static SerializedNameValuePair serializedNameValuePair(Object key, Object value, HttpPartType type, HttpPartSerializerSession serializer, HttpPartSchema schema, EnumSet<AddFlag> flags) {
        return key == null ? null : new SerializedNameValuePair(StringUtils.stringify(key), value, type, serializer, schema, flags == null ? false : flags.contains((Object)AddFlag.SKIP_IF_EMPTY));
    }

    private static SerializedHeader serializedHeader(Object key, Object value, HttpPartSerializerSession serializer, HttpPartSchema schema, EnumSet<AddFlag> flags) {
        return key == null ? null : new SerializedHeader(StringUtils.stringify(key), value, serializer, schema, flags == null ? false : flags.contains((Object)AddFlag.SKIP_IF_EMPTY));
    }

    private static boolean isNameValuePairArray(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return false;
        }
        return NameValuePair.class.isAssignableFrom(o.getClass().getComponentType());
    }

    private static boolean isHeaderArray(Object o) {
        if (o == null || !o.getClass().isArray()) {
            return false;
        }
        return Header.class.isAssignableFrom(o.getClass().getComponentType());
    }

    @Override
    public OMap toMap() {
        return super.toMap().a("RestCall", new DefaultFilteringOMap().a("client", this.client).a("hasInput", this.hasInput).a("ignoreErrors", this.ignoreErrors).a("interceptors", this.interceptors).a("partSerializer", this.partSerializer).a("requestBodySchema", this.requestBodySchema).a("response", this.response).a("serializer", this.serializer));
    }
}

