/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.assertions;

import org.apache.juneau.assertions.Assertion;
import org.apache.juneau.assertions.FluentComparableAssertion;
import org.apache.juneau.internal.FluentSetters;

@FluentSetters(returns="FluentIntegerAssertion<R>")
public class FluentIntegerAssertion<R>
extends FluentComparableAssertion<R> {
    private final Integer value;

    public FluentIntegerAssertion(Integer value, R returns) {
        this(null, value, returns);
    }

    public FluentIntegerAssertion(Assertion creator, Integer value, R returns) {
        super(creator, value, returns);
        this.value = value;
    }

    @Override
    protected int compareTo(Object value) {
        return this.value.compareTo(((Number)value).intValue());
    }

    @Override
    protected Object equivalent(Object o) {
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return o;
    }

    @Override
    public FluentIntegerAssertion<R> msg(String msg, Object ... args) {
        super.msg(msg, args);
        return this;
    }

    @Override
    public FluentIntegerAssertion<R> stderr() {
        super.stderr();
        return this;
    }

    @Override
    public FluentIntegerAssertion<R> stdout() {
        super.stdout();
        return this;
    }
}

