/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.util.List;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilterBuilder;
import org.apache.juneau.transform.BeanInterceptor;

public final class AnnotationBeanFilterBuilder<T>
extends BeanFilterBuilder<T> {
    public AnnotationBeanFilterBuilder(Class<T> annotatedClass, List<Bean> annotations) throws Exception {
        super(annotatedClass);
        for (Bean b : annotations) {
            if (!b.properties().isEmpty()) {
                this.bpi(StringUtils.split(b.properties()));
            }
            if (!b.bpi().isEmpty()) {
                this.bpi(StringUtils.split(b.bpi()));
            }
            if (!b.typeName().isEmpty()) {
                this.typeName(b.typeName());
            }
            if (b.sort()) {
                this.sortProperties(true);
            }
            if (b.fluentSetters()) {
                this.fluentSetters(true);
            }
            if (!b.excludeProperties().isEmpty()) {
                this.bpx(StringUtils.split(b.excludeProperties()));
            }
            if (!b.bpx().isEmpty()) {
                this.bpx(StringUtils.split(b.bpx()));
            }
            if (!b.bpro().isEmpty()) {
                this.bpro(StringUtils.split(b.bpro()));
            }
            if (!b.bpwo().isEmpty()) {
                this.bpwo(StringUtils.split(b.bpwo()));
            }
            if (b.propertyNamer() != PropertyNamerDefault.class) {
                this.propertyNamer(b.propertyNamer());
            }
            if (b.interfaceClass() != Object.class) {
                this.interfaceClass(b.interfaceClass());
            }
            if (b.stopClass() != Object.class) {
                this.stopClass(b.stopClass());
            }
            if (b.beanDictionary().length > 0) {
                this.dictionary(b.beanDictionary());
            }
            if (b.dictionary().length > 0) {
                this.dictionary(b.dictionary());
            }
            if (b.interceptor() == BeanInterceptor.Default.class) continue;
            this.interceptor(b.interceptor());
        }
    }
}

